/* Autor: Adam Iwanicki */

#include<map>
#include<vector>
#include<iostream>
#include<queue>

using namespace std;

const int MAXP = 50;
const int INFTY = MAXP+1;

int last, p, r, w1, w2, maxdist;
string s1, s2;
map<string,int> dict;

vector<vector<int > > adj;

int translate(const string s) 
{
  if( dict.find(s) == dict.end() ) {
    dict[s] = last++;
  }
  return dict[s];
}

int dist(int w1, int w2)
{
  queue<int> q;
  vector<int> visited(p,INFTY);
  visited[w1]=0;
  q.push(w1);
  while (q.size()) {
    int w = q.front();
    q.pop();
    for(unsigned int i=0; i<adj[w].size(); ++i) {
      int tmp = adj[w][i];
      if (visited[tmp] == INFTY) {
        visited[tmp] = visited[w]+1;
        q.push(tmp);
        if (tmp == w2) {
          return visited[tmp];
        }
      }
    }
  }
  return INFTY;
}

int main()
{
  int num = 0;
  while(1) {
    cin >> p >> r;
    if(p==0 || r==0) break;

    last = 0;
    dict.clear();
    adj.clear();
    adj.resize(p);

    for(int i=0; i<r; ++i) {
      cin >> s1 >> s2;
      w1 = translate(s1);
      w2 = translate(s2);
      adj[w1].push_back(w2);
      adj[w2].push_back(w1);
    }

    maxdist = 0;
    for(int i=0; i< p; ++i) {
      for(int j=i+1; j<p; ++j) {
        maxdist = max(maxdist, dist(i,j));
      }
    }

    cout << "Network " << ++num << ": ";
    if (maxdist == INFTY) {
      cout << "DISCONNECTED";
    } else {
      cout << maxdist;
    }
    cout << endl;
  }
}
