/*
 * Solution for the problem I from ACM 2006.
 *
 * Author: Janusz Parfieniuk 2006.12
 */

#include <iostream>
#include <map>

using namespace std;

// maximal number of persons in the network
#define NUMBER_OF_PERSONS	50
// number representing infinity in matrix representing degree of separation
#define	INFINITE		NUMBER_OF_PERSONS + 1


/* 
 * fuction looks for personName in the map and returns value that
 * is assigned to that name, if association doesn't exist, assigns
 * it new value (denoted by lastIndex) 
 */
int getPersonIndex(map<string, int>& namesMap, string personName, int& lastIndex);

/* 
 * function returns lower of two passed integers 
 */
int min(int, int);

/* 
 * solution is implementation of Floyd-Warshall algorithm
 */
int main()
{
	map<string, int> namesMap; // translation from person names to their indexes
	string firstPerson, secondPerson; // for input purposes 
	int noPersons, noRelations;
	int degree[NUMBER_OF_PERSONS][NUMBER_OF_PERSONS]; // persons adjacency matrix
	int firstPersonIndex, secondPersonIndex, lastUsedIndex;
	int i, j, k, maxDegree, networkNumber=0;
	
	cin >> noPersons;
	cin >> noRelations;
	
	while (noPersons != 0 || noRelations != 0) {
		
		networkNumber++;
		lastUsedIndex = 0;
		maxDegree = 0;
		for (i=0; i<noPersons; i++) 
			for (j=0; j<noPersons; j++) 
				degree[i][j] = INFINITE;
		for (i=0; i<noPersons; i++) 
			degree[i][i] = 0;
			
		namesMap.clear();
		// reading arguments
		for (i=0; i<noRelations; i++) {
			cin >> firstPerson;
			cin >> secondPerson;

			firstPersonIndex = getPersonIndex(namesMap, firstPerson, lastUsedIndex);
			secondPersonIndex = getPersonIndex(namesMap, secondPerson, lastUsedIndex);
			degree[firstPersonIndex][secondPersonIndex] = 1;
			degree[secondPersonIndex][firstPersonIndex] = 1;
		
		}
		
		// Floyd-Warshal
		for (k=0; k<noPersons; k++) 
			for(i=0; i<noPersons; i++) 
				for (j=0; j<noPersons; j++) 
					degree[i][j] = min(degree[i][j], degree[i][k] + degree[k][j]);

		// computation of solution
		for (i=0; i<noPersons; i++)  
			for (j=0; j<noPersons; j++) 
				if (maxDegree < degree[i][j])
					maxDegree = degree[i][j];
		
		cout << "Network " << networkNumber << ": ";
		if (maxDegree >= noPersons)
			cout << "DISCONNECTED";
		else
			cout << maxDegree;
		cout << endl;
			

		cin >> noPersons;
		cin >> noRelations;
	}
	return 0;
}

int getPersonIndex(map<string, int>& namesMap, string personName, int& lastUsedIndex)
{
	if (namesMap.find(personName) == namesMap.end()) {
		namesMap[personName] = lastUsedIndex;
		return lastUsedIndex++;
	}
	return namesMap[personName];
}
	

int min(int a, int b)
{
	if (a < b)
		return a;
	return b;
}

