import java.util.*;
import java.math.*;
import java.io.*;

class Pockets2 {
    static int[] chr_to_k;
    static int[] chr_to_s;

    static int[] mul;
    static int[] inv;
    static int[][] pos;
    static int[][] edge;
    
    static int[][] lnk;
    static int[][] head;
    static int[][] flip;

    static int[][] u;
    static int[] st;

    static BufferedReader input;
    static ArrayList<String> input_buffer_;

    static String[] read_line() {
        while (input_buffer_.size() < 2) {
            try {
                String line = input.readLine();

                String[] tokens = line.split(" ");
                for (int i = 0; i < tokens.length; ++i) {
                    if (tokens[i].length() > 0) {
                        input_buffer_.add(tokens[i]);
                    }
                }
            } catch (Exception ex) {
                System.out.println("Unexpected exception at read_line");
                return new String[0];
            }
        }

        String[] result = new String[2];
        result[0] = input_buffer_.get(0);
        result[1] = input_buffer_.get(1);
        input_buffer_.remove(0);
        input_buffer_.remove(0);

        return result;
    }

    static void initializeData(int N) {
        chr_to_k = new int[256];
        chr_to_s = new int[256];

        mul = new int[2];
        inv = new int[2];
        pos = new int[2][N + 1];
        edge = new int[2][2];

        lnk = new int[N * N][2];
        head = new int[N * N][2];
        flip = new int[N * N][2];

        u = new int[N][N + 1];
        st = new int[(N * (N + 1)) / 2];
        
        chr_to_k['R'] = 0;
        chr_to_k['L'] = 0;
        chr_to_k['D'] = 1;
        chr_to_k['U'] = 1;

        chr_to_s['R'] = 0;
        chr_to_s['L'] = 1;
        chr_to_s['D'] = 0;
        chr_to_s['U'] = 1;

        InputStreamReader stdin = new InputStreamReader(System.in);
        input = new BufferedReader(stdin);
        input_buffer_ = new ArrayList<String>();
    }

    static int ID(int k, int x, int y) {
        return mul[k] * x + mul[k ^ 1] * y;
    }

    static int DI(int k, int id, int n) {
        return (id / mul[k]) % n;
    }

	public static void main(String[] args) {
        initializeData(100);

        for (int tt = 1; ; tt++) {
            int nn, cutsNum;

            String[] tmp = read_line();
            nn = Integer.parseInt(tmp[0]);
            cutsNum = Integer.parseInt(tmp[1]);

            if (nn == 0 && cutsNum == 0) {
                break;
            }

            int n = nn + 1;

            mul[0] = 1;
            mul[1] = n;

            for (int k = 0; k < 2; ++k) {
                inv[k] = 0;
                edge[k][0] = 0;
                edge[k][1] = n;
                for (int i = 0; i <= n; ++i) {
                    pos[k][i]=i;
                }
            }

            for (int i = 0; i < n * n; ++i) {
                for (int k = 0; k < 2; ++k) {
                    lnk[i][k] = -1;
                    head[i][k] = i;
                    flip[i][k] = 0;
                }
            }

            for (int cc = 0; cc < cutsNum; ++cc) {
                String[] tmp2 = read_line();
                int sep = Integer.parseInt(tmp2[0]);
                char str = tmp2[1].charAt(0);

                int k = chr_to_k[str];

                int cut = pos[k][sep];

                int side = inv[0] ^ inv[1];
                int part = (chr_to_s[str] + inv[k]) % 2;

                int[] dist = new int[2];
                for (int i = 0; i < 2; ++i) {
                    dist[i] = Math.abs(edge[k][i] - cut);
                }

                if (dist[part] > dist[part ^ 1]) {
                    part ^= 1;
                    inv[k] ^= 1;
                }

                int from = (part == 0) ? edge[k][0] : cut;
                int to   = (part == 0) ? cut        : edge[k][1];

                for (int j = edge[k ^ 1][0]; j <= edge[k ^ 1][1] - 1; ++j) {
                    for (int i = from; i <= to - 1; ++i) {
                        int src = ID(k, i, j);
                        int dst = ID(k, 2 * cut - 1 - i, j);

                        int cur = head[src][side ^ 1];

                        while (cur >= 0) {
                            int nxt = lnk[cur][side ^ 1];

                            flip[cur][k] ^= 1;

                            int tail = head[dst][side ^ 1];
                            lnk[cur][side ^ 1] = tail;
                            lnk[tail][side] = cur;
                            lnk[cur][side] = -1;
                            head[dst][side ^ 1] = cur;

                            cur = nxt;
                        }
                    }
                }

                for (int i = 0; i <= n; ++i) {
                    pos[k][i] = cut + Math.abs(cut - pos[k][i]) * (1 - 2 * part);
                }

                edge[k][part] = cut;
            }

            int ans=0;

            for (int k = 0; k < 2; ++k) {
                for (int s = 0; s < 2; ++s) {
                    for (int j = 0; j < n; ++j) {
                        for (int i = 0; i <= n; ++i) {
                            u[j][i] = 0;
                        }
                    }

                    int ss = 0;

                    for (int cur = head[ID(0, edge[0][0], edge[1][0])][0]; cur >= 0; cur = lnk[cur][0]) {
                        int x = DI(k, cur, n);
                        int y = DI(k ^ 1, cur, n);


                        int l = x + (s + flip[cur][k]) % 2;

                        if (l == 0 || l == n) {
                            st[ss++] = 1;
                            st[ss++] = -1;
                            u[y][l] += 2;
                        } else {
                            st[ss++] = 1 - 2 * u[y][l];
                            u[y][l]++;
                        }
                    }

                    int h = 0;
                    for (int i = 0; i < ss - 1; ++i) {
                        h += st[i];
                        if (h == 0) ans++;
                    }
                }
            }

            System.out.print("Case " + tt + ": " + ans + " pockets\n");
        }
    }
};
