/* autor: Marek Żylak */

#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <cctype>
#include <cmath>
#include <cassert>
#include <complex>
#include <algorithm>
#include <vector>
#include <string>
#include <map>
#include <set>
#include <queue>
#include <deque>
#include <list>

using namespace std;

#define REP(i,n) for (int tmp##i=(int)(n),i=0;i<tmp##i;i++)
#define FOR(i,a,b) for (int tmp##i=(int)(b),i=(a);i<=tmp##i;i++)
#define FORD(i,a,b) for (int tmp##i=(int)(b),i=(a);i>=tmp##i;i--)
#define FORE(i,c) for(__typedef((c).begin()) i=(c).begin();i!=(c).end();i++)
#define PB push_back
#define TB pop_back

typedef long long L;
typedef pair<int,int> PI;
typedef vector<int> VI;
typedef list<int> LI;
typedef vector<LI> VLI;
typedef complex<double> C;

#define N 100
#define ID(k,x,y) (mul[k]*(x)+mul[(k)^1]*(y))
#define DI(k,id) (((id)/mul[k])%n)

map<int,int> chr_to_k;
map<int,int> chr_to_s;

int mul[2];
int inv[2];
int pos[2][N+1];
int edge[2][2];

int lnk[N*N][2];
int head[N*N][2];
int flip[N*N][2];

int u[N][N+1];
int st[N*(N+1)*2];

int main()
{
	chr_to_k['R'] = 0;
	chr_to_k['L'] = 0;
	chr_to_k['D'] = 1;
	chr_to_k['U'] = 1;

	chr_to_s['R'] = 0;
	chr_to_s['L'] = 1;
	chr_to_s['D'] = 0;
	chr_to_s['U'] = 1;

	for (int tt=1;;tt++) {
		int nn,cutsNum;
		scanf("%d%d",&nn,&cutsNum);

		if (nn==0 && cutsNum==0) return 0;

		int n=nn+1;

		mul[0]=1;
		mul[1]=n;

		REP(k,2) inv[k]=0;

		REP(k,2) edge[k][0]=0;
		REP(k,2) edge[k][1]=n;

		REP(k,2) FOR(i,0,n) pos[k][i]=i;

		REP(i,n*n) REP(k,2) lnk[i][k]=-1;
		REP(i,n*n) REP(k,2) head[i][k]=i;
		REP(i,n*n) REP(k,2) flip[i][k]=0;

		REP(cc,cutsNum) {
			int sep;
			char str[2]; 
			scanf("%d%s",&sep,str);

			int k=chr_to_k[str[0]];

			int cut=pos[k][sep];

			int side=inv[0]^inv[1];
			int part=(chr_to_s[str[0]]+inv[k])%2;

			int dist[2];
			REP(i,2) dist[i]=abs(edge[k][i]-cut);

			if (dist[part]>dist[part^1]) {
				part^=1;
				inv[k]^=1;
			}

			int from = (part==0) ? edge[k][0] : cut;
			int to   = (part==0) ? cut        : edge[k][1];

			FOR(j,edge[k^1][0],edge[k^1][1]-1) FOR(i,from,to-1) {
				int src=ID(k,i,j);
				int dst=ID(k,2*cut-1-i,j);

				int cur=head[src][side^1];

				while (cur >= 0) {
					int nxt=lnk[cur][side^1];

					flip[cur][k]^=1;

					int tail=head[dst][side^1];
					lnk[cur][side^1]=tail;
					lnk[tail][side]=cur;
					lnk[cur][side]=-1;
					head[dst][side^1]=cur;

					cur=nxt;
				}
			}

			FOR(i,0,n) pos[k][i]=cut+abs(cut-pos[k][i])*(1-2*part);

			edge[k][part]=cut;
		}

		int ans=0;

		REP(k,2) REP(s,2) {
	  	  REP(j,n) FOR(i,0,n) u[j][i]=0;

		  int ss=0;

		  for (int cur=head[ID(0,edge[0][0],edge[1][0])][0];cur>=0;cur=lnk[cur][0]) {
			  int x=DI(k,cur);
			  int y=DI(k^1,cur);


			  int l=x+(s+flip[cur][k])%2;

			  if (l==0 || l==n) {
				  st[ss++]=1;
				  st[ss++]=-1;
				  u[y][l]+=2;
			  } else {
				  st[ss++]=1-2*u[y][l];
				  u[y][l]++;
			  }
		  }

		  int h=0;
		  REP(i,ss-1) {
			  h+=st[i];
			  if (h==0) ans++;
		  }
	  	}

		printf("Case %d: %d pockets\n",tt,ans);
	}
}
