/*
 * Solution in C++ for problem G - Pilgrimage
 * ACM World Finals 2006
 * Author: Wojciech Czerwiski * 
 */

#include <vector>
#include <cstdio>
#include <string>
#include <cmath>

using namespace std;

#define REP(i,n) for(i=0;i<(typeof(i))n;i++)
#define MAX(x,y) ((x)>(y))?(x):(y)
#define MAXN 50
#define PAY 0
#define IN 1
#define OUT 2
#define COLLECT 3

int getCode(string s) {
	if (s == "PAY") return PAY;
	if (s == "IN") return IN;
	if (s == "OUT") return OUT;
	return COLLECT;	
}

vector<int> divisors(int k) {
	vector<int> v;
	int i, sqrtk = int(floor(sqrt(double(k))));
	for(i=1; i<=sqrtk; i++) {
		if (k%i == 0) {
			if (i != k/i) {
				v.push_back(i);
				v.push_back(k/i);
			} else v.push_back(i);	
		}	
	}
	return v;
}

int main() {
	int i, j, n;
	string instr;
	int value;
	char inst[8];
	vector<pair<int,int> > vp;
	vector<int> good, help;
	bool first;
	bool inout;
	int sum ;
	int modif;
	while (true) {
		sum = 0;
		first = true;
		inout = false;
		modif = 0;
		scanf("%d", &n);
		if (n == 0) break;
		REP(i,n) {
      		scanf("%s%d", inst, &value);
      		instr = string(inst);
			int code = getCode(instr);      					
			switch (code) {
				case PAY:
					if (inout && first) first = false;
					inout = false;
					sum += value;
					break;
				case IN:
					if (first) modif += value;
					else {
						vp.push_back(make_pair(modif,sum));
						modif += value;
					}
					sum = 0;
					inout = true;
					break;
				case OUT:
					if (first) modif -= value;
					else {
						vp.push_back(make_pair(modif,sum));
						modif -= value;	
					}
					sum = 0;					
					inout = true;		
					break;
				default:
					break;
			}
		}
		if (vp.size() == 0) {
			int res = MAX(1,1-modif);
			printf("SIZE >= %d\n", res);
			continue;
		}
		REP(i,vp.size()) {
			if (i == 0) {
				good = divisors(vp[0].second);
				REP(j,good.size()) {
					if (good[j] - vp[0].first > 0) help.push_back(good[j] - vp[0].first);						
				}
			} else {
				REP(j,good.size()) {
					if ((good[j] + vp[i].first > 0) && (vp[i].second%(good[j] + vp[i].first) == 0))
						help.push_back(good[j]);
				}
			}
			good = help;	
			help.clear();		
		}
		REP(i,good.size()) {
			if (good[i] + modif > 0) help.push_back(good[i]);
		}
		good = help;		
		if (good.size() == 0) printf("IMPOSSIBLE\n");
		else {
			sort(good.begin(), good.end());
			REP(i,good.size()) {
				printf("%d", good[i]);
				if (i < (int) (good.size()-1)) printf(" ");
				else printf("\n");
			}
		}
		vp.clear();		
		good.clear();
		help.clear();	
	}
	return 0;
}
