/* Model solution of task Pilgrimage
 * Author: Aleksander Mielczarek, Jakub Radoszewski
 */

#include <cstdio>
#include <cstring>
#include <cstdlib>
#include <cmath>
#include <string>
#include <algorithm>
#include <vector>
using namespace std;

#define MAX_N 50

int n, len;
string name[MAX_N];
char names[10];
int k[MAX_N];
vector<int> result, result_rev;

bool no_pays()
{
  if (!len)
  {
    puts("SIZE >= 1");
    return true;
  }
  int num_pays = 0;
  int inout = 0; /* sum of all IN-OUT's */
  for (int i = 0; i < len; i++)
  {
    if (name[i] == "PAY")
      num_pays++;
    else
    {
      if (name[i] == "OUT")
        k[i] = -k[i];
      inout += k[i];
    }
  }
  if (!num_pays)
  {
    printf("SIZE >= %d\n", 1 + max(-inout, 0));
    return true;
  }
  return false;
}

/* m is a candidate for the number of pilgrims at position
 * pos-1 in our sequence */
bool possible(int m, int pos)
{
  while (pos < len)
  {
    if (name[pos] == "IN" || name[pos] == "OUT")
      m += k[pos++];
    if (m < 1)
      return false;
    
    int sum_pay = 0;
    while (pos < len && name[pos] == "PAY")
      sum_pay += k[pos++];
    if (sum_pay % m)
      return false;
  }
  return true;
}

void doit()
{
  int i = 0;
  int inout = 0; /* inout is sum of a prefix consisting of only IN-OUT's */
  while (name[i] != "PAY") /* there still is a PAY */
    inout += k[i++];
  
  int sum = 0;
  while (name[i] == "PAY") /* there still is a not PAY */
    sum += k[i++];
  
  result.clear();
  int number = int(floor(sqrt(double(sum) + 1e-9)));
  for (int j = 1; j <= number; j++)
    if (sum % j == 0)
    {
      if (j > inout && possible(j, i))
        result.push_back(j - inout);
      if (sum / j > inout && j * j != sum && possible(sum / j, i))
        result_rev.push_back(sum / j - inout);
    }
  while (!result_rev.empty())
  {
    result.push_back(result_rev.back());
    result_rev.pop_back();
  }
}

int main()
{
  while (1)
  {
    scanf("%d", &n);
    if (!n)
      break;
    len = 0;
    bool is_inout = false;
    while (n--)
    {
      scanf("%s%d", names, k + len);
      name[len] = string(names);
      if (name[len] == "COLLECT")
        continue;
      if (name[len] == "PAY" && !is_inout)
        continue;
      if (name[len] == "IN" || name[len] == "OUT")
        is_inout = true;
      len++;
    }
    while (len > 0 && name[len - 1] == "PAY")
      len--;

    if (no_pays())
      continue;
    doit();
    for (int i = 0, size = (int)result.size(); i < size - 1; i++)
      printf("%d ", result[i]);
    if (!result.empty())
      printf("%d\n", result.back());
    else
      puts("IMPOSSIBLE");
  }
  return 0;
}
