/*package pl.edu.mimuw.radoszewski.mielczarek.pilgrimage;*/

import java.util.*;
import java.io.*;
/*import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;*/

public class Pilgrimage {

	/*
	 * Model solution of task Pilgrimage Author: Aleksander Mielczarek, Jakub
	 * Radoszewski
	 */

	public static int MAX_N = 50;

	private static BufferedReader stdin = new BufferedReader(
			new InputStreamReader(System.in));

	public static String string_pay = new String("PAY");
	public static String string_in = new String("IN");
	public static String string_out = new String("OUT");
	public static String string_collect = new String("COLLECT");
	
	public static int n, len;

	public static String name[] = new String[MAX_N];

	public static String names;

	static int k[] = new int[MAX_N];

	public static Vector<Integer> result, result_rev;

	public static boolean no_pays() {
		if (len == 0) {
			System.out.println("SIZE >= 1");
			return true;
		}
		int num_pays = 0;
		int inout = 0; /* sum of all IN-OUT's */
		for (int i = 0; i < len; i++) {
			if (name[i].equals(string_pay))
				num_pays++;
			else {
				if (name[i].equals(string_out))
					k[i] = -k[i];
				inout += k[i];
			}
		}
		if (num_pays == 0) {
			System.out.println("SIZE >= "
					+ Integer.toString(1 + Math.max(-inout, 0)));
			return true;
		}
		return false;
	}

	/*
	 * m is a candidate for the number of pilgrims at position pos-1 in our
	 * sequence
	 */
	public static boolean possible(int m, int pos) {
		while (pos < len) {
			if (name[pos].equals(string_in) || name[pos].equals(string_out))
				m += k[pos++];
			if (m < 1)
				return false;

			int sum_pay = 0;
			while (pos < len && name[pos].equals(string_pay))
				sum_pay += k[pos++];
			if (sum_pay % m != 0)
				return false;
		}
		return true;
	}

	static void doit() {
		int i = 0;
		int inout = 0; /* inout is sum of a prefix consisting of only IN-OUT's */
		while (!name[i].equals(string_pay))
			/* there still is a PAY */
			inout += k[i++];

		int sum = 0;
		while (name[i].equals(string_pay))
			/* there still is a not PAY */
			sum += k[i++];

		result.clear();
		int number = (int) (Math.floor(Math.sqrt(sum + 1e-9)));
		for (int j = 1; j <= number; j++)
			if (sum % j == 0) {
				if (j > inout && possible(j, i))
					result.add(j - inout);
				if (sum / j > inout && j * j != sum && possible(sum / j, i))
					result_rev.add(sum / j - inout);
			}
		
		for (int szekspir = result_rev.size()-1; szekspir >= 0; szekspir--) {
			result.add(result_rev.get(szekspir));
		}
		result_rev.clear();
	}

	public static void main(String[] args) {
		result = new Vector<Integer>();
		result_rev = new Vector<Integer>();
		while (true) {
			StringTokenizer st = null;
			try {
				st = new StringTokenizer(stdin.readLine());
			} catch (Exception e) {
			}
			;
			int n = Integer.parseInt(st.nextToken());

			if (n == 0)
				break;
			len = 0;
			boolean is_inout = false;
			while (n-- > 0) {
				try {
					st = new StringTokenizer(stdin.readLine());
				} catch (Exception ee) {
				}
				;
				names = st.nextToken();
				k[len] = Integer.parseInt(st.nextToken());
				name[len] = names;
				if (name[len].equals(string_collect))
					continue;
				if (name[len].equals(string_pay) && !is_inout)
					continue;
				if (name[len].equals(string_in) || name[len].equals(string_out))
					is_inout = true;
				len++;
			}
			while (len > 0 && name[len - 1].equals(string_pay))
				len--;

			if (no_pays())
				continue;
			doit();
			for (int i = 0, size = (int) result.size(); i < size - 1; i++)
				System.out.print(Integer.toString(result.get(i)) + " ");
			if (!result.isEmpty())
				System.out.println(result.lastElement());
			else
				System.out.println("IMPOSSIBLE");
			result.clear();
		}
		return;
	}

}
