import java.util.*;
import java.io.*;

/**
 * The Java solution for problem Bipartite Numbers, 
 * ACM ICPC Finals 2006, problem D.
 * @author Marcin Pilipczuk
 *
 */
public class BipartiteNumbers1 {
	static public int n;
	static public int[] cycles;
	static public int[] startCycle;
	
	private static class Remainders{
		int digit;
		public int[] r;
		
		Remainders(int dig){
			digit = dig;
			r = new int[n];
			for(int i = 0; i<n; ++i)
				r[i] = -1;
			int act = digit % n;
			int iter = 1;
			while(r[act] == -1){
				r[act] = iter;
				act = (10 * act + digit) % n;
				iter++;
			}
			cycles[digit] = iter - r[act];
			startCycle[digit] = r[act];
		}
		
		public int minGreater(int remainder, int border){
			if (r[remainder] == -1)
				return -1;
			if (r[remainder] > border)
				return r[remainder];
			if (startCycle[digit] > r[remainder])
				return -1;
			return r[remainder] + cycles[digit] * ((border - r[remainder])/cycles[digit]+1);
		}
		
		public int maxLesser(int remainder, int border){
			if (r[remainder] == -1 || r[remainder] >= border)
				return -1;
			if (r[remainder] < startCycle[digit])
				return r[remainder];
			return r[remainder] + cycles[digit] * ((border-r[remainder]-1)/cycles[digit]);
		}
	}
	
	private static class Answer implements Comparable<Answer>{
		int firstDigit;
		int firstLength;
		int secondDigit;
		int secondLength;
		Answer(int fd, int fl, int sd, int sl){
			firstDigit = fd;
			firstLength = fl;
			secondDigit = sd;
			secondLength = sl;
		}
		public void output(){
			System.out.print(" " + (firstLength-secondLength) + 
					" " + firstDigit + " " + 
					+ secondLength + " " + (firstDigit+secondDigit));
		}
		public int compareTo(Answer a){
			if (a==null)
				return -1;
			/*System.out.print("Comparing"); this.output();
			System.out.print(" To"); a.output();
			System.out.println();*/
			if (a.firstLength != firstLength)
				return a.firstLength < firstLength ? 1 : -1;
			if (a.firstDigit != firstDigit)
				return a.firstDigit < firstDigit ? 1 : -1;
			if (a.secondLength < secondLength)
				return secondDigit < 0 ? -1 : 1;
			if (a.secondLength > secondLength)
				return a.secondDigit < 0 ? 1 : -1;
			if (a.secondDigit < secondDigit)
				return 1;
			if (a.secondDigit > secondDigit)
				return -1;
			return 0;
		}
	}
	
	private static Remainders[] rem;
	private static Answer ans = null;
	
	/**
	 * @param args
	 */
	public static void main(String[] args) throws IOException {
		BufferedReader bufReader = new BufferedReader(new InputStreamReader(System.in));
		while(true){
			n = Integer.parseInt((new StringTokenizer(bufReader.readLine())).nextToken());
			if (n == 0)
				break;
			int ncopy = n, logn = 0, ldigit = 1;
			while (ncopy > 0){
				ldigit = ncopy % 10;
				ncopy /= 10;
				logn++;
			}
			rem = new Remainders[10];
			cycles = new int[10];
			startCycle = new int[10];
			ans = null;
			for(int i=1; i<=9; ++i)
				rem[i] = new Remainders(i);
			for(int i=1; i<=9; ++i)
				for(int r=0; r<n; ++r)
					for(int j=0; j<=9; ++j) if (i!=j){
						int sign = j<i ? -1 : 1;
						int secDig = (j-i) * sign;
						int reqR = j<i ? r : ((n-r)%n);
						int minJ = rem[secDig].minGreater(reqR, 0);
						if (minJ == -1)
							continue;
						int borderI = logn + (i<=ldigit ? 0 : -1);
						if (borderI < minJ)
							borderI = minJ;
						int idI = rem[i].minGreater(r, borderI);
						if (idI == -1)
							continue;
						int idJ = j<i ? rem[secDig].maxLesser(reqR, idI) : minJ;
						Answer nans = new Answer(i, idI, j-i, idJ);
						if (nans.compareTo(ans) == -1)
							ans = nans;
					}
			System.out.print("" + n + ":");
			ans.output();
			System.out.println();
		}
	}
}
