#include <iostream>
#include <cstdio>
#include <vector>
#include <cmath>

#define REP(i,n) for(int i=0; i<(n); ++i)
#define REP2(i,n) for(i=0; i<(n); ++i)
#define REPD(i,n) for(int i=(n)-1; i>=0; --i)
#define FOR(i,a,b) for(int i=(a); i<=(b); ++i)
#define FORL(i,a,b) for(int i=(a); i<(b); ++i)
#define FOR2(i,a,b) for(i=(a); i<=(b); ++i)
#define FORD(i,a,b) for(int i=(a); i>=(b); --i)
#define VAR(v,n) __typeof(n) v = n
#define FORE(i,v) for(VAR(i, (v).begin()); i!=(v).end(); ++i)
#define ALL(v) (v).begin(), (v).end()
#define PB push_back
#define MP(a,b) make_pair(a,b)
#define _INT(a) scanf("%d", &a)
#define INT(a) int a; _INT(a)
#define _VINT(v,n) do { (v).resize((n)); REP(i,(n)) { INT(j); (v)[i]=j; } } while(0)
#define VINT(v,n) vector<int> v; _VINT(v,n)
#define CHAR(a) char foo_##a[2]; scanf("%s", foo_##a); char a = foo_##a[0]

using namespace std;


class Point {
public:
	double x, y, z;
	int id;
	Point() {
		x = y = z = 0;
		id = -1;
	}
	
	Point(double x, double y, double z) {
		this->x = x;
		this->y = y;
		this->z = z;
		id = -1;
	}
	
	void add(Point direction) {
		x += direction.x;
		y += direction.y;
		z += direction.z;
	}
};

#define VP vector <Point>
#define VE vector <pair<int, int> >

class Test {
public:
    VP P;
    VE E;
};

vector <Test *> testy[10];


VP GeneratePoints(Point start, Point direction, int n) {
	VP Li;
	for (int i = 0; i < n; i++) {
		Li.push_back(start);
		start.add(direction);
	}
	return Li;
}

void InitPoints(VP &list, VP &P) {
	FORE(i, list) {
		i->id = P.size();
		P.PB(*i);
	}
}

void Make_Connection(VP &list, VE &E) {
	for (int i = 1; i < list.size(); i++) {
		E.PB(MP(list[i - 1].id, list[i].id));
	}
}

void Make_Connection_Cycle(VP &list, VE &E) {
	for (int i = 1; i < list.size(); i++) {
		E.PB(MP(list[i - 1].id, list[i].id));
	}
	E.PB(MP(list[0].id, list[list.size() - 1].id));
}


void Print(VP &P, VE &E) {
    if (P.size() <= 100 && E.size() <= 100) {
        int testnum = (E.size() - 1) / 10;
        testy[testnum].push_back(new Test());
        testy[testnum].back()->P = P;
        testy[testnum].back()->E = E;
	}
}

void Print(FILE *file, Test *test) {
//      	cout << test->P.size() << " " << test->E.size() << endl;
      	fprintf(file, "%d %d\n", test->P.size(), test->E.size());
    	FORE(i, test->P) {
    		fprintf(file, "%.5lf %.5lf %.5lf\n", (i -> x),  (i -> y), (i -> z));
    	}
    	
    	FORE(i, test->E) {
    		fprintf(file, "%d %d\n", (i -> first + 1), (i -> second + 1) );
    	}
}

const double PI = acos(-1);
VP GeneretePointsAround(Point p, int n) {
	VP R;
	FOR (i, 0, (n - 1)) {
		R.PB(Point(p.x + sin(2.0 * PI * i / n), p.y + cos(2.0 * PI * i / n), p.z));
	}
	return R;
}

void Make_Connection(VP &L1, VP &L2, VE &E) {
	for (int i = 0; i < L1.size(); i++) {
		E.PB(MP(L1[i].id, L2[i].id));
	}
}

void Make_Connection_ALL_ALL(VP &L1, VP &L2, VE &E) {
	FORE (i, L1)
		FORE (j, L2)
			E.PB(MP(i->id, j -> id));
}

void Make_Connection_Inside(VP &L1, VE &E) {
	FOR (i, 0, L1.size() - 1)
		FOR (j, i + 1, L1.size() - 1) {
			E.PB(MP(L1[i].id, L1[j].id));
		}
}

void Rotate(VP &L1) {
	VAR(first, L1[0]);
	for (int i = 1; i < L1.size(); i++) {
		L1[i - 1] = L1[i];
	}
	L1[L1.size() - 1] = first;
}

VP GenereteRandomListOfPoint(Point p, int n) {
	VP R;
	FOR (i, 0, n - 1) {
		R.PB(p);
		p.x += rand() + 1;
		p.y += rand() + 1;
		p.z += rand() + 1;
	}
	return R;
}

VP GenereteRandomListOfPoint_BETA(Point p, int n) {
	VP R;
	FOR (i, 0, n - 1) {
		R.PB(p);
		p.x += rand() + 1;
		p.z += rand() + 1;
	}
	return R;
}

void addTests(int type) {
	switch(type) {
		case 1: //UNSTABLE
		
		FOR (n, 2, 100) {
			VP P;
			VE E;
			VAR(Li, GeneratePoints(Point(0, 0, 0), Point(0, 0, 0.01), n));
			InitPoints(Li, P);
			Make_Connection(Li, E);
			Print(P, E);
		}
		break;
	
		case 2: 
		FOR (n, 4, 22) { //UNSTABLE
			VP P;
			VE E;
			VAR(L1, GeneretePointsAround(Point(0, 0, 0), n));
			VAR(L2, GeneretePointsAround(Point(0, 0, 10), n));
			InitPoints(L1, P);
			InitPoints(L2, P);
			Make_Connection_Cycle(L1, E);
			Make_Connection_Cycle(L2, E);
			Make_Connection(L1, L2, E);
			Print(P, E);
		}
		break;
	
		case 3: 
		FOR (n, 4, 22) { //STABLE
			VP P;
			VE E;
			VAR(L1, GeneretePointsAround(Point(0, 0, 0), n));
			VAR(L2, GeneretePointsAround(Point(0, 0, 10), n));
			InitPoints(L1, P);
			InitPoints(L2, P);
			Make_Connection_Cycle(L1, E);
			Make_Connection_Cycle(L2, E);
			Make_Connection(L1, L2, E);
			Rotate(L1);
			Make_Connection(L1, L2, E);
			Print(P, E);
		}
		break;
		
		case 4: //STABLE
		FOR (n, 4, 22) {
			VP P;
			VE E;
			VAR(L1, GeneretePointsAround(Point(0, 0, 0), n));
			InitPoints(L1, P);
			VP L2;
			L2.PB(Point(1, 1, 1));
			InitPoints(L2, P);
			Make_Connection_ALL_ALL(L1, L2, E);
			
			Print(P, E);
		}
		break;
		
		case 5: //NON-STATIC
		FOR (n, 4, 22) {
			VP P;
			VE E;
			VAR(LOUT, GeneratePoints(Point(0, 0, 2), Point(5, 5, 5), 3));
			
			InitPoints(LOUT, P);
			
			VAR(L1, GeneretePointsAround(Point(1, 1, 0), n));
			InitPoints(L1, P);
			VP L2;
			L2.PB(LOUT[0]);
			Make_Connection_ALL_ALL(L1, L2, E);
			
			
			VAR(L3, GeneretePointsAround(Point(10, 10, 0), n));
			InitPoints(L3, P);
			VP L4;
			L4.PB(LOUT[2]);
			Make_Connection_ALL_ALL(L3, L4, E);
			
			
			Make_Connection(LOUT, E);
			
			Print(P, E);
		}
		break;
		
		case 6: //UNSTABLE
		FOR (n, 4, 7)
		FOR (m, 4, 19)  {
			VP P;
			VE E;
			VAR(LOUT, GeneratePoints(Point(0, 0, 2), Point(0, 0, 10), 3));
			
			InitPoints(LOUT, P);
			
			VAR(L1, GeneretePointsAround(Point(1, 1, 0), n));
			InitPoints(L1, P);
			
			
			VP L2;
			L2.PB(LOUT[0]);
			Make_Connection_ALL_ALL(L1, L2, E);
			
			
			VAR(L3, GeneretePointsAround(Point(10, 10, 0), n));
			InitPoints(L3, P);
			VP L4;
			L4.PB(LOUT[2]);
			Make_Connection_ALL_ALL(L3, L4, E);
			
			
			VAR(LX, GeneretePointsAround(LOUT[1], m));
			InitPoints(LX, P);
			Make_Connection_ALL_ALL(LX, LOUT, E);
			Make_Connection_Inside(LX, E);
			
			
			Make_Connection(LOUT, E);
			
			Print(P, E);
		}
		break;
		
		case 7: //NON-STATIC
		FOR (n, 4, 24) {
			VP P;
			VE E;
			VAR(LOUT, GeneratePoints(Point(0, 0, 0), Point(4, 0, 0), 3));
			InitPoints(LOUT, P);
			VAR(L1, GenereteRandomListOfPoint(Point(0, 0, 0), n));
			InitPoints(L1, P);
			Make_Connection_ALL_ALL(L1, LOUT, E);
			
			Print(P, E);
		}
		break;
		
		case 8: //NON-STATIC
		FOR (n, 4, 24) {
			VP P;
			VE E;
			VAR(L1, GenereteRandomListOfPoint(Point(0, 0, 0), n));
			InitPoints(L1, P);
			Make_Connection_Inside(L1, E);
			
			Print(P, E);
		}
		break;
		
		
		case 9: //UNSTABLE
		FOR (n, 4, 24) {
			VP P;
			VE E;
			VAR(LOUT, GeneratePoints(Point(0, 0, 0), Point(4, 0, 0), 3));
			InitPoints(LOUT, P);
			VAR(L1, GenereteRandomListOfPoint_BETA(Point(0, 0, 0), n));
			InitPoints(L1, P);
			Make_Connection_ALL_ALL(L1, LOUT, E);
			
			Print(P, E);
		}
		break;
		
		case 10: //UNSTABLE
		FOR (n, 2, 100) {
			VP P;
			VE E;
			VAR(Li, GeneratePoints(Point(0, 0, 0), Point(0, 0, -0.0001), n));
			InitPoints(Li, P);
			Make_Connection(Li, E);
			Print(P, E);
		}
	
		default:
			break;
	}
}

int main(int argc, char **argv) {
	FOR (i, 1, 10)
        addTests(i);
    FOR (i, 1, 10) {
        char buffer[256];
        sprintf(buffer, "test%d.in", i);
        FILE *file = fopen(buffer, "w");
        FORE (j, testy[i - 1])
            Print(file, *j);
        fprintf(file, "%d %d\n", 0, 0);
        fclose(file);
    }

	return 0;
}
