/* Zadanie ???

   Rozwiązanie wzrocowe
   Autor: Szymon Acedański
*/

#include <cstdio>
#include <vector>
#include <algorithm>
#include <cassert>
#include <cstring>

using namespace std;

#define REP(i,n) for(int i=0; i<(n); ++i)
#define REP2(i,n) for(i=0; i<(n); ++i)
#define REPD(i,n) for(int i=(n)-1; i>=0; --i)
#define FOR(i,a,b) for(i=(a); i<=(b); ++i)
#define FORD(i,a,b) for(int i=(a); i>=(b); --i)
#define VAR(v,n) __typeof(n) v = n
#define FORE(i,v) for(VAR(i, (v).begin()); i!=(v).end(); ++i)
#define ALL(v) (v).begin(), (v).end()
#define PB push_back
#define MP(a,b) make_pair(a,b)
#define _INT(a) scanf("%d", &a)
#define INT(a) int a; _INT(a)
#define _VINT(v,n) do { (v).resize((n)); REP(i,(n)) { INT(j); (v)[i]=j; } } while(0)
#define VINT(v,n) vector<int> v; _VINT(v,n)
#define CHAR(a) char foo_##a[2]; scanf("%s", foo_##a); char a = foo_##a[0]

typedef vector<int> VI;

long long MOD = 0x7fffffff;

// rozszerzony algorytm Euklidesa
// zwraca x, y t.¿e a*x + b*y = gcd(a,b)
// a, b >= 0
long long egcd(long long a, long long b, long long& x, long long& y) {
  if (b) {
    long long x1, d1 = egcd(b, a % b, x1, x);
    y = x1 - (a / b) * x;
    return d1;
  } else {
    x = 1;
    y = 0;
    return a;
  }
}

// reszta z dzielenia a przez b. Dzia³a równie¿ dla a < 0.
long long mod(long long a, long long b) {
  return a >= 0 ? a % b : b - (-a % b);
}

// odwrotno¶æ a modulo m (a i m wzglêdnie pierwsze)
long long inv_mod(long long a, long long m)
{
  long long x, y;
  egcd(a, m, x, y);
  return mod(x, m);
}

// CLASS T

class T {
    public:
        long long v;

        T(long long v = 0) : v(mod(v, MOD)) { }

        /*operator bool() {
            return v;
        }*/

        operator long long() {
            return v;
        }

        long long vv() {
            if (v > MOD/2)
                return v-MOD;
            return v;
        }

};

T operator +(T a, T b) {
    return mod(a.v+b.v, MOD);
}

T operator -(T a, T b) {
    return mod(a.v-b.v, MOD);
}

T operator -(T a) {
    return mod(-a.v, MOD);
}

T operator *(T a, T b) {
    return mod(a.v*b.v, MOD);
}

T operator /(T a, T b) {
    return T(a)*T(inv_mod(b.v, MOD));
}

/* =============================================================== GAUSS */

#define VT vector<T>

VT eqs[330];
T eqsb[330];
int eq, cols;

void print_equations();

// zwraca 0 - jedno rozwi±zanie (w x)
//        1 - wiele rozwi±zañ (przyk³adowe w x)
//       -1 - brak rozwi±zañ
// indeksowanie: a[wiersz][kolumna]
// modyfikuje podane wektory
int gauss()
{
  int m = eq;
  int n = cols;
  int k, r;

  //print_equations();

  REP2(k, min(m,n)) {
    int i, j;
    FOR(j, k, n-1) FOR(i, k, (m-1)) if (!(eqs[i][j] == 0)) goto found;
    break;
  found:
    if (j != k) REP(t, m) swap(eqs[t][j], eqs[t][k]);
    if (i != k) { swap(eqs[i], eqs[k]); swap(eqsb[i], eqsb[k]); }
    FOR(j, k+1, m-1) {
      T l = eqs[j][k]/eqs[k][k];
      FOR(i, k+1, n-1) {
          eqs[j][i] = eqs[j][i] - l * eqs[k][i];
      }
      eqsb[j] = eqsb[j] - l*eqsb[k];
    }
  }
  r = k;

  FOR(k, r, m-1) if (!(eqsb[k] == 0)) { return -1; }
  return r < m;
}

vector<VI> sas;
VT X, Y, Z;
VI A, B;

#define MAX_FRAC_DIGITS 8

T readt() {
    bool neg = false;
    long long a;
    char sep, sign;
    char frac[MAX_FRAC_DIGITS+1];

    do { sign = getchar(); } while (sign != '-' && (sign < '0' || sign > '9'));
    if (sign == '-')
        neg = true;
    else
        ungetc(sign, stdin);

    scanf("%lld%c", &a, &sep);

    assert(a >= 0);
    
    if (sep == '.')
        scanf("%s", frac);
    else {
        ungetc(sep, stdin);
        frac[0] = '\0';
    }

    int l = strlen(frac);
    assert(l <= MAX_FRAC_DIGITS);

    T t(a);
    REP(i, MAX_FRAC_DIGITS) {
        t = t*T(10);
        t = t + T((i >= l ? '0' : frac[i]) - '0');
    }

    if (neg) t = -t;

    return t;
}

void make_equations(int node)
{
    T x1 = X[node], y1 = Y[node], z1 = Z[node];
    if (z1 == 0) return;
    FORE(s, sas[node]) {
        int a = A[*s], b = B[*s];
        T x2 = X[a], y2 = Y[a], z2 = Z[a];
        if (x1 == x2 && y1 == y2 && z1 == z2) {
            x2 = X[b]; y2 = Y[b]; z2 = Z[b];
        }
        /*printf("%d: %d--%d\n", node+1, a+1, b+1);
        printf("  (%lld,%lld,%lld) -> (%lld, %lld, %lld)\n",
                x1.vv(), y1.vv(), z1.vv(),
                x2.vv(), y2.vv(), z2.vv());*/


        eqs[eq][*s]   = x2-x1;
        eqs[eq+1][*s] = y2-y1;
        eqs[eq+2][*s] = z2-z1;
    }

    eqsb[eq]   = T();
    eqsb[eq+1] = T();
    eqsb[eq+2] = T(-1);
    eq += 3;
}

void print_equations()
{
    printf("\n");
    REP(i, cols) {
        printf("(%d, %d) ", A[i]+1, B[i]+1);
    }
    printf("\n");

    REP(j, eq) {
        REP(i, cols) {
            printf("%6lld ", eqs[j][i].vv());
        }
        printf(" | %6lld\n", eqsb[j].vv());
    }
}

int main()
{
    REP(t,100000) {
        INT(n); INT(m);
        if (n==0 && m == 0) return 0;

        printf("Sculpture %d: ", t+1);

        cols = m;

        sas.clear();
        sas.resize(n);

        X.clear(); Y.clear(); Z.clear();

        REP(i, n) {
            X.PB(readt());
            Y.PB(readt());
            Z.PB(readt());
        }

        A.clear(); B.clear();

        REP(i, m) {
            INT(a); INT(b); a--; b--;
            A.PB(a); B.PB(b);
            sas[a].PB(i);
            sas[b].PB(i);
        }

        REP(i,3*n) {
            eqs[i].clear();
            eqs[i].resize(cols);
        }
        eq = 0;
        REP(i, n) make_equations(i);
        //print_equations();
        switch (gauss()) {
            case -1: printf("NON-STATIC\n"); break;
            case  0: printf("STABLE\n"); break; 
            case  1: printf("UNSTABLE\n"); break;
        }
    }
    return 0;
}

