/*
 * Weryfikacja poprawnosci programu
 * Autor: Adam Iwanicki
 */
#include<cstdio>
#include<string>
#include<vector>
#include<cmath>

#define MAXNUM    50
#define MAXAMOUNT 100
#define MINVALUE  -100
#define MAXVALUE  1000
#define MAXFRAC   2
#define REP(I,N)  for(int I=0;I<(N);++I)
#define PB        push_back
#define INFTY     1000000000

using namespace std;

int P,I;
vector<vector<int> > v;
int amounts[2][MAXNUM];
int num=0;

/* Wierzcholki 0..n-1 */
#define MAX_N 202

struct kraw
{
  int v1,v2,w,c; /* wierzch, waga, przepustowosc */
  int n,wh; /* sasiad */
};

int n,m,ost;
vector<kraw> t[MAX_N];
int d[MAX_N];
kraw par[MAX_N]; /* ojcowie */

/* Dodaje krawedz v1->v2 o wadze w i przepustowosci c. */
void add_edge(int v1,int v2,int w,int c)
{
  kraw e1;
  e1.v1=v1; e1.v2=v2; e1.w=w; e1.c=c;
  e1.wh = t[v1].size();
  e1.n =-1;
  t[v1].PB(e1);
}

void Bellman_Ford(int pocz,int kon)
{
  bool relaxed[MAX_N];
  REP(i,n) { d[i]=INFTY; par[i].v1=-1; relaxed[i]=false; }
  d[pocz]=0; relaxed[pocz]=true;
  bool dorel=true;
  while (dorel && d[kon]>ost)
  {
    dorel=false;
    REP(i,n) if (relaxed[i])
    {
      REP(j,(int)t[i].size()) if (t[i][j].c && d[t[i][j].v2]>d[i]+t[i][j].w)
      {
        relaxed[t[i][j].v2]=true;
        dorel=true;
        d[t[i][j].v2]=d[i]+t[i][j].w;
        par[t[i][j].v2]=t[i][j];
      }
      relaxed[i]=false;
    }
  }
}

/* Przeksztalca graf. */
int transform(int pocz,int kon)
{
  kraw e1;
  int v=kon,mi=INFTY;
  while (v!=pocz) /* o ile przeplyw wzrosnie */
  {
    mi=min(mi,par[v].c);
    v=par[v].v1;
  }
  v=kon;
  while (v!=pocz) /* przesylamy przeplyw, ew. dodajemy krawedzie */
  {
    kraw e=par[v];
    t[e.v1][e.wh].c-=mi;
    if (e.n!=-1) t[e.v2][e.n].c+=mi;
    else
    {
      e1.v1=e.v2; e1.v2=e.v1; e1.w=-e.w; e1.c=mi;
      e1.wh=t[e1.v1].size(); e1.n=e.wh;
      t[e.v1][e.wh].n=e1.wh;
      t[e1.v1].PB(e1);
    }
    v=e.v1;
  }
  return mi;
}

/* Zwraca wartosc przeplywu. */
int Busacker_Gowen(int pocz,int kon)
{
  bool poss=true;
  int wyn=0;
  ost=-1000000000;
  while (poss)
  {
    Bellman_Ford(pocz,kon);
    if (par[kon].v1==-1) poss=false;
    else
    {
      wyn+=transform(pocz,kon)*d[kon];
      ost=d[kon];
    }
  }
  return wyn;
}


void oblicz(void)
{
  int pocz = 0;
  int kon = P+I+1;
  n = kon+1;
  REP(i,n) t[i].clear();
  REP(i,P)
    add_edge(pocz,i+1, 0, amounts[0][i]);
  REP(i,I)
    add_edge(i+P+1,kon, 0, amounts[1][i]);

  REP(i,P)
    REP(j,I) {
      if (v[i][j] >0)
        add_edge(i+1,j+P+1,v[i][j], INFTY);
    }

  int min = Busacker_Gowen(pocz,kon);

  REP(i,n) t[i].clear();
  REP(i,P)
    add_edge(pocz,i+1, 0, amounts[0][i]);
  REP(i,I)
    add_edge(i+P+1,kon, 0, amounts[1][i]);

  REP(i,P)
    REP(j,I) {
      if (v[i][j] >0)
        add_edge(i+1,j+P+1,-v[i][j], INFTY);
    }
  
  int max = -Busacker_Gowen(pocz,kon);

  printf("Problem %d: %.2f to %.2f\n",num,(float) min/100, (float) max/100);
  
}


int main()
{
  while(1) {
    scanf("%d %d", &P, &I);
    if (P==0 && I==0) break;

    ++num;

    v.clear();
    for(int i=0; i<P; ++i) {      
      int pom;
      scanf("%d", &pom);
      amounts[0][i] = pom;
    }

    for(int i=0; i<I; ++i) {
      int pom;
      scanf("%d", &pom);
      amounts[1][i] = pom;
    }


    for(int i=0; i<P; ++i) {
      vector<int> row;
      for(int j=0; j<I; ++j) {
	float fl;
	int val;
	scanf("%f", &fl);
	if( fl < 0 ) {
	  val = -1;
	} else {
	  val = (int) round(fl*100);
	}
        row.push_back(val);
      }
      v.push_back(row);
    }

    oblicz();
  }

   return 0;
}
