#include <iostream>
#include <cmath>
#define INF	1<<30
#define PRZERWA -1000000


using namespace std;

int policz_minimum(int l_ciast, int l_lodow, int krotCiast[50], int krotLodow[50], int ceny[50][50])
{
	int i, j, l_krokow;
	/* na początek skojarzenie jest puste */
	int skojarzone[50][50];
	
	for (i=0; i<50; i++) 
		for (j=0; j<50; j++) 
			skojarzone[i][j] = 0;
	
	/* inicjowanie liczby dostępnych ciastek i lodow */
	int dostCiast[50];
	for (i=0; i<l_ciast; i++) 
		dostCiast[i] = krotCiast[i];
	
	int dostLodow[50];
	for (i=0; i<l_lodow; i++) 
		dostLodow[i] = krotLodow[i];

	int k, n = l_ciast + l_lodow;
	
	/* tablice do wyszukiwania najkrótszych scieżek */
	int p[101], d[101];

	/* liczenie liczby krokow do wykonania */
	l_krokow = 0;
	for (i=0; i<l_ciast; i++) 
		l_krokow += krotCiast[i];

	/* algorytm */
	int min, tmp; // zmienne umozliwiajace znalezienie najmniej odległego wierzchołka (min - odległość, tmp - indeks w tablicy d[i])
	int krok, akt, poprz; 
	int sa_zmiany = 1;
	int krotnosc;
	while (l_krokow > 0) {
		// bellman-ford
		
		// inicjowanie tablic d i p 
		// dla ciastek, jezeli nie wszystkie sa skojarzone - łączymy je ze źródłem krawędzią o wadze 0(numer n)
		for (i=0; i<l_ciast; i++) {
			if (dostCiast[i] > 0) {
				d[i] = 0;
				p[i] = n;
			} 
			else {
				d[i] = INF;
				p[i] = -1;
			}
		}
		// lody nie mają bezpośredniego połączenia ze źródłem
		for (i=0, j=l_ciast; i<l_lodow; i++, j++) {
			d[j] = INF;
			p[j] = -1;
		}
		sa_zmiany = 1;
		while(sa_zmiany) {
			sa_zmiany = 0;
			for (i=0; i<l_ciast; i++) {
				for (j=0, k=l_ciast; j<l_lodow; j++, k++) {
					if (skojarzone[i][j] != 0) {
					// jeżeli jest jakieś skojarzenie między i i j to znaczy, że w grafie
					// mamy krawędź od loda j do ciastka i
						if (d[i] > d[k] - ceny[i][j]) {
							d[i] = d[k] - ceny[i][j];
							p[i] = k;
							sa_zmiany = 1;
						}
					}
					// krawędź od ciastka i do loda j istnieje jeżeli kombinacja tego
					// loda z danym ciastkiem jest dopuszczalna
					if (ceny[i][j] >= 0) {
						if (d[k] > d[i] + ceny[i][j]) {
							d[k] = d[i] + ceny[i][j];
							p[k] = i;
							sa_zmiany = 1;
						}
					}
				}
			}
		}


		/* szukamy konca najkrotszej sciezki */
		min = INF;
		tmp = 0;
		for (i=l_ciast; i<n; i++) {
			if (d[i] < min && dostLodow[i-l_ciast] > 0) {
				tmp = i;
				min = d[i];
			}
		}

		/* ile razy mozna pojsc ta sciezka 
		 * jest to minimum po 
		 *   - liczbie dostępnych lodów w wierzchołku docelowym
		 *   - liczbie dostępnych ciastek w wierzchołku początkowym
		 *   - krotności skojarzeń po których wracamy
		 */
		krotnosc = dostLodow[tmp-l_ciast]; 
		krok = 0;
		akt = p[tmp];
		poprz = p[akt];
		while (poprz != n) {
			if (krotnosc > skojarzone[akt][poprz-l_ciast])
				krotnosc = skojarzone[akt][poprz-l_ciast];
			akt = p[poprz];
			poprz = p[akt];
		}
		if (krotnosc > dostCiast[akt])
			krotnosc = dostCiast[akt];
		

		// uaktualniamy skojarzenie
		dostLodow[tmp-l_ciast]-= krotnosc; 
		krok = 0;
		akt = tmp;
		poprz = p[akt];
		while (poprz != n) {
			if (krok%2) {
				skojarzone[akt][poprz-l_ciast] -= krotnosc;
			} else {
				skojarzone[poprz][akt-l_ciast] += krotnosc;
			}
			krok++;
			akt = poprz;
			poprz = p[akt];
		}

		dostCiast[akt]-= krotnosc;

		// wykonaliśmy krotność kroków za jednym "zamachem" 
		l_krokow -= krotnosc;
	}
	
	/* nalezy policzyc koszt uzyskanego skojarzenia */
	int koszt=0;
	for (i=0; i<l_ciast; i++) 
		for (j=0; j<l_lodow; j++) 
			if (skojarzone[i][j] > 0)
				koszt += skojarzone[i][j] * ceny[i][j];
	
	return koszt;
}


int main()
{
	int p, i, j, k, ceny[50][50]; 
	int krotnoscCiastek[50];
	int krotnoscLodow[50], l_skojarzen;
	double tmp;
	cout.precision(2);
	int problem=0;
	while (1) {
		problem++;
		cin >> p;
		cin >> i;
		if (p == 0)
			break;
		cout << "Problem " << problem << ": ";
		for (j=0; j<p; j++) 
			cin >> krotnoscCiastek[j];
		for (j=0; j<i; j++) 
			cin >> krotnoscLodow[j];

		for (j=0; j<p; j++) {
			for(k=0; k<i; k++) {
				cin >> tmp;
				ceny[j][k] = (int) round(tmp * 100); // aby uniknąć błędów zaokrągleń
			}
		}

		cout << fixed << (double) policz_minimum(p, i, krotnoscCiastek, krotnoscLodow, ceny) / 100 << " to " ;
		/* 0 < cena polaczenia <= 10, po przeskalowaniu 0 < cena polaczenia <= 1000
		 * a więc aby obliczyć maksymalny zysk wystarczy zamienić ceny tak aby cena = 1001 - aktualna_cena
		 * a później ten proces odwrócić 
		 */
		for (j=0; j<p; j++) 
			for(k=0; k<i; k++) 
				if (ceny[j][k] > 0)
					ceny[j][k] = 1001 - ceny[j][k];
		l_skojarzen=0;
		for (j=0; j<p; j++)
			l_skojarzen += krotnoscCiastek[j];
		int x =  policz_minimum(p, i, krotnoscCiastek, krotnoscLodow, ceny);
		x = l_skojarzen*1001 - x;
		cout << fixed << (double) x / 100 << endl;
	}
	return 0;
}
