/*
Solution to ACM-2006 Problem B: "Remember the A'la mode"
Tomasz Boguslawski, December 2006
Warsaw Univesity
*/

#include <iostream>
#include <cmath>
using namespace std;
#define infinity 1000000000

class ALaMode_Solver 
{
     private: 
      int pie_types, ice_types, desserts;
      int pie_count[51]; int ice_count[51];
      int price[51][51];
      int ssp(); // succesive shortest path
     public:
      bool load_data();
      void solve(int problem_num);
};

bool ALaMode_Solver::load_data()
// loads one set of data
// returns false if two zeroes were loaded
// prices are converted to integer values (multiplied by 100)
{
     cin >> pie_types; cin >> ice_types;
     if (pie_types==0) return false;
     for (int i=1; i<=pie_types; i++) cin >> pie_count[i];
     for (int j=1; j<=ice_types; j++) cin >> ice_count[j];
     double f;
     for (int i=1; i<=pie_types; i++)
       for (int j=1; j<=ice_types; j++) {
           cin >> f;
           if (f==-1) price[i][j]=infinity; else price[i][j]=(int)round(f*100);
       }
     desserts=0;  for (int i=1; i<=pie_types; i++) desserts+=pie_count[i];
     return true;
};
 
void ALaMode_Solver::solve(int problem_num)
// uses SSP to count both minimum and maximum profit
// displays both values 
{
     int minimum_profit = this->ssp(); 
     for (int i=1; i<=pie_types; i++) 
       for (int j=1; j<=ice_types; j++) 
         if (price[i][j]!=infinity) price[i][j]=-price[i][j]+2000;
     int mp = this->ssp();
     int maximum_profit=-(mp - desserts*2000);
     cout << "Problem " << problem_num << ": ";
     cout.precision(2);
     cout << fixed << (minimum_profit/100.0) << " to ";
     cout << fixed << (maximum_profit/100.0) << endl; 
};

int ALaMode_Solver::ssp()
// succesive shortest path algorithm on compressed graph
{
   int i,j; 
   // in arrays "dist" and "prev" pie types are numbered
   // from 1 to pie_types and ice cream types are
   // numbered from pie_types+1 to pie_types+ice_types
   int dist[101]; int prev[101];
   int matched[51][51]; int mV[51]; int mW[51];

   // start with empty matching:
    for (i=1; i<=pie_types; i++)
      for (j=1; j<=ice_types; j++) matched[i][j]=0;
    for (i=1; i<=pie_types; i++) mV[i]=0;
    for (j=1; j<=ice_types; j++) mW[j]=0;
    int matched_count=0; // number of matched pairs
    
    // find minimum weight perfect matching:
    while(matched_count!=desserts) {
        // bellmann-ford algorithm - initialisation:
        for (i=1; i<=pie_types+ice_types; i++) { 
            dist[i]=infinity; prev[i]=-1; 
        }
        for (i=1; i<=pie_types; i++) if (mV[i]!=pie_count[i]) {
            dist[i]=0; prev[i]=0; 
        };
        
        // bellmann-ford algorithm - main loop
        // the loop will stop when no distance is changed
        bool anything_changed;
        do {
            anything_changed=false;
            for (i=1; i<=pie_types; i++) for (j=1; j<=ice_types; j++) {
                if (matched[i][j]!=0) {
                   // matched edge j->i
                   if (dist[pie_types+j] + (-price[i][j]) < dist[i]) {
                      dist[i]=dist[pie_types+j] + (-price[i][j]);
                      prev[i]=pie_types+j;
                      anything_changed=true;
                   };
                };
                if (matched[i][j]!=pie_count[i]) {
                   // unmatched edge i->j
                   if (dist[i]+price[i][j] < dist[pie_types+j]) {
                      dist[pie_types+j]=dist[i]+price[i][j];
                      prev[pie_types+j]=i;
                      anything_changed=true;
                   };   
                };                                                                                       
            };
        } while (anything_changed);
        
        // choose the shortest path
        int minimum=infinity; int t=-1;
        for (j=1; j<=ice_types; j++) 
          if ((mW[j]!=ice_count[j]) && (dist[pie_types+j]<minimum)) { minimum=dist[pie_types+j]; t=j; };
          
        // count how many times the path could be used:
        int how_many=ice_count[t]-mW[t]; // number of unmatched in ice group t
        int left=prev[pie_types+t]; int right=t; bool add=true; bool done=false;
        do {
           if (add) {
              if (prev[left]==0) done=true;
              else right=prev[left]-pie_types;
           } else {
              if (matched[left][right]<how_many) how_many=matched[left][right];
              left=prev[right+pie_types];
           };
           add=!add;
        } while (!done);
        if ((pie_count[left]-mV[left]) < how_many) how_many=(pie_count[left]-mV[left]);
        
        // augment matching "how_many" times
        left=prev[pie_types+t]; right=t; add=true; done=false;
        do {
          if (add) {
            matched[left][right]+=how_many; mV[left]+=how_many; mW[right]+=how_many;
            if (prev[left]==0) done=true; else right=prev[left]-pie_types;
          } else {
            matched[left][right]-=how_many; mV[left]-=how_many; mW[right]-=how_many;
            left=prev[right+pie_types];
          };
          add=!add;
        } while (!done);
        matched_count+=how_many;
    };
    
    // we have the perfect matching, now we will count the profit:
    int profit=0;
    for (i=1; i<=pie_types; i++)
      for (j=1; j<=ice_types; j++) profit+=matched[i][j]*price[i][j];
    return profit;
};

int main()
{
    ios_base::sync_with_stdio(0); // magic spell for IOSTREAM better performance
    ALaMode_Solver solver; int problem_num=0;
    while (solver.load_data()) solver.solve(++problem_num);
    return 0;
}

