import java.io.*;
import java.util.*;


public class LowCostAirTravel1 {
	public class Vertex implements Comparable<Vertex> {
		public Vertex(int ticketNumArg, int cityNumArg, List<Integer> cityOnTicketArg,	List<Integer> citiesLeftArg) {
			ticketNum = ticketNumArg;
			cityNum = cityNumArg;
			citiesOnTicketLeft = cityOnTicketArg;
			citiesToVisitLeft = citiesLeftArg;
		}
		public Vertex(int ticketNumArg) {
			ticketNum = ticketNumArg;
			cityNum = 0;
			citiesOnTicketLeft = new ArrayList<Integer>();
			citiesToVisitLeft = new ArrayList<Integer>();
		}
		public int ticketNum;
		public int cityNum;
		public List<Integer> citiesOnTicketLeft;
		public List<Integer> citiesToVisitLeft;

		public Vertex parent = this;
	
		public int compareTo(Vertex v) {
			return ticketNum != v.ticketNum ?
					ticketNum - v.ticketNum :
						(citiesOnTicketLeft.size() != v.citiesOnTicketLeft.size() ? 
								citiesOnTicketLeft.size() - v.citiesOnTicketLeft.size() : 
											citiesToVisitLeft.size() - v.citiesToVisitLeft.size());
		}
	}


	public class Edge implements Comparable<Edge> {
		public Vertex to;
		public int cost;
		public Edge(Vertex v, int c) {
			to   = v;
			cost = c;
		}
	
		public int compareTo(Edge e) {
			return cost - e.cost == 0 ? 
					to.compareTo(e.to) : cost - e.cost;
		}
	}


	public class Dijkstra {
		public int inf = 1000000000;
	
		public SortedMap<Vertex, Integer> go(SortedMap<Vertex, List<Edge>> g, Vertex start) {
			SortedMap<Vertex, Integer> vertToCost = new TreeMap<Vertex, Integer>();
			SortedSet<Edge> edgeSet = new TreeSet<Edge>();
		
			Iterator<Vertex> vertexIter = g.keySet().iterator();
			while(vertexIter.hasNext()) {
				Vertex v = vertexIter.next();
				vertToCost.put(v, inf);
			}
			vertToCost.put(start, 0);
			edgeSet.add(new Edge(start, 0));
		
			while(edgeSet.size() > 0) {
				Edge shortestPath = edgeSet.first(); 
				edgeSet.remove(shortestPath);
				Vertex v = shortestPath.to;
				Iterator<Edge> edgeIter = g.get(v).iterator();
				while(edgeIter.hasNext()) {
					Edge e = edgeIter.next();
					int baseCost = vertToCost.get(e.to);
					int otherCost = vertToCost.get(v);
					if(otherCost + e.cost < baseCost) {
						edgeSet.add(new Edge(e.to, otherCost + e.cost));
						vertToCost.put(e.to, otherCost + e.cost);
						e.to.parent = v;
					}
				}
			
			}
			return vertToCost;
		}
	}


	public class Ticket {
		public Ticket(int costArg, List<Integer> citiesArg) {
			cost = costArg;
			cities = citiesArg;
		}
		public int cost = 0;
		public List<Integer> cities;
	}
	public List<Ticket> tickets = new ArrayList<Ticket>();

	public List<Integer> route = new ArrayList<Integer>();
	
	public SortedMap<Vertex, List<Edge>> travelGraph = new TreeMap<Vertex, List<Edge>>();
	
	public Vertex start;
	
	public void addTicket(int costArg, List<Integer> citiesArg) {
		tickets.add(new Ticket(costArg, citiesArg));
	}
	
	public void setRoute(List<Integer> routeArg) {
		route = routeArg;
	}
	
	static public int removeFirstHeadIfHeadsEqualRemoveAndRetSecondHead(List<Integer> first, List<Integer> second) {
		int secondHead;
		Iterator<Integer> firstIter = first.iterator();
		Iterator<Integer> secondIter = second.iterator();
		secondHead = secondIter.next();
		if(firstIter.next() == secondHead)
			firstIter.remove();
		secondIter.remove();
		return secondHead;
	}
	
	private Vertex makeVertex(int ticketNum, int cityNum, List<Integer> citiesToVisitLeft, List<Integer> citiesOnTicketLeft) {
		Vertex v = new Vertex(ticketNum, cityNum, citiesOnTicketLeft, citiesToVisitLeft);
		if(!travelGraph.containsKey(v)) {
			travelGraph.put(v, new ArrayList<Edge>());
			if(citiesOnTicketLeft.size() > 0)
				addCitiesFromTicketEdges(v);
			if(citiesToVisitLeft.size() > 0) 
				addNewTicketEdges(v);
		}
		return v;
	}
	
	private void addNewTicketEdges(Vertex v) {
		Iterator<Ticket> ticketIter = tickets.iterator();
		int ticketNum = 0;
		while(ticketIter.hasNext()) {
			Ticket ticket = ticketIter.next();
			ticketNum++;
			if(v.cityNum > 0 && v.cityNum != ticket.cities.get(0))
				continue;
			List<Integer> citiesToVisitLeft = new ArrayList<Integer>(v.citiesToVisitLeft);
			List<Integer> citiesOnTicketLeft = new ArrayList<Integer>(ticket.cities);
			int cityNum = v.cityNum;
			if(citiesToVisitLeft.size() > 0)
				cityNum = removeFirstHeadIfHeadsEqualRemoveAndRetSecondHead(citiesToVisitLeft, citiesOnTicketLeft);
			Vertex v2 = makeVertex(ticketNum, cityNum, citiesToVisitLeft, citiesOnTicketLeft);
			travelGraph.get(v).add(new Edge(v2, ticket.cost));
		}
	}
	
	private void addCitiesFromTicketEdges(Vertex v) {
		List<Integer> citiesToVisitLeft = new ArrayList<Integer>(v.citiesToVisitLeft);
		List<Integer> citiesOnTicketLeft = new ArrayList<Integer>(v.citiesOnTicketLeft);
		int cityNum = v.cityNum;
		if(citiesToVisitLeft.size() > 0)
			cityNum = removeFirstHeadIfHeadsEqualRemoveAndRetSecondHead(citiesToVisitLeft, citiesOnTicketLeft);
		Vertex v2 = makeVertex(v.ticketNum, cityNum, citiesToVisitLeft, citiesOnTicketLeft);
		travelGraph.get(v).add(new Edge(v2, 0));
	}
	
	public void generateTravelGraph() {
		travelGraph = new TreeMap<Vertex, List<Edge>>();
		start = makeVertex(0, 0, route, new ArrayList<Integer>());
	}
	
	public List<Integer> getMinCostPath() {
		Dijkstra dijkstra = new Dijkstra();
		SortedMap<Vertex, Integer> minPaths= dijkstra.go(travelGraph, start);
		Iterator<Vertex> vertIter = minPaths.keySet().iterator();
		int minCost = dijkstra.inf;
		Vertex pathEnd = start;
		while(vertIter.hasNext()) {
			Vertex v = vertIter.next();
			if(v.citiesToVisitLeft.size() == 0) {
				int cost = minPaths.get(v);
				if(cost < minCost) {
					minCost = cost;
					pathEnd = v;
				}
			}
		}
		List<Integer> ticketNums = new ArrayList<Integer>();
		ticketNums.add(pathEnd.ticketNum);
		pathEnd = pathEnd.parent;
		while(pathEnd.parent != pathEnd) {
			if(pathEnd.ticketNum != ticketNums.get(0))
				ticketNums.add(0,pathEnd.ticketNum);
			pathEnd = pathEnd.parent;
		}
		ticketNums.add(0, minCost);
		return ticketNums;
	}
	
	public static void main(String[] args) throws IOException {
		BufferedReader bufReader = new BufferedReader(new InputStreamReader(System.in));
		int caseNum = 0;
		while(true){
			caseNum++;
			StringTokenizer st = new StringTokenizer(bufReader.readLine()); 
			int n = Integer.parseInt(st.nextToken());
			if(n == 0) break;
			LowCostAirTravel1 lowCostAirTravel = new LowCostAirTravel1();
			for(int i = 0; i < n; i++) {
				st = new StringTokenizer(bufReader.readLine());
				int ticketCost = Integer.parseInt(st.nextToken());
				int m = Integer.parseInt(st.nextToken());
				List<Integer> ticketCities = new ArrayList<Integer>();
				for (int j = 0; j < m; j++)
					ticketCities.add(Integer.parseInt(st.nextToken()));
				lowCostAirTravel.addTicket(ticketCost, ticketCities);
			}
			st = new StringTokenizer(bufReader.readLine());
			n = Integer.parseInt(st.nextToken());
			if(n == 0) break;
			int tripNum = 0;
			for(int i = 0; i < n; i++) {
				tripNum++;
				st = new StringTokenizer(bufReader.readLine());
				int m = Integer.parseInt(st.nextToken());
				lowCostAirTravel.route = new ArrayList<Integer>();
				for (int j = 0; j < m; j++)
					lowCostAirTravel.route.add(Integer.parseInt(st.nextToken()));
				lowCostAirTravel.generateTravelGraph();
				ListIterator<Integer> res = lowCostAirTravel.getMinCostPath().listIterator();
				System.out.print("Case " + caseNum + ", Trip " + tripNum + ": Cost = " + res.next() + "\n");
				System.out.print("  Tickets used:");
				while(res.hasNext()) {
					System.out.print(" " + res.next());
				}
				System.out.print("\n");
			}
		}
	}
}
