#include <vector>
#include <iostream>
#include <algorithm>

using namespace std;

#define INF 2000000000

#define MAX_TICKETS 21
#define MAX_CITIES 21
#define MAX_CITIES_TO_VISIT 21

class state
{
	public:
		// Stan w ktorym jestesmy to trojka uporzadkowana
		int last_ticket;
		int city_on_ticket;
		int visited_cities;
		int city;

		// d jesto odlegloscia od zrodla
		int d;

		vector<pair<state *, int> > adj;

		state(int lt = -1, int cot = -1, int vc = -1) {last_ticket = lt; city_on_ticket = cot; visited_cities = vc;};


		void add_edge(state *s, int w) {adj.push_back(pair<state *, int>(s, w));};
		void del_edge(state *w);
};


void state::del_edge(state *w)
{
	vector<pair<state *, int> > new_adj;
	for(unsigned int i = 0; i < adj.size(); ++i)
		if(adj[i].first != w)
			new_adj.push_back(adj[i]);

	adj = new_adj;
	
}


// Implementacja grafu
class graph
{
	private:
		// Stan NIL nigdy nie moze byc osiaganiety w algorytmie Dijkstry
		state *NIL;

		// Tablica pi z algorytmu Relax
		vector<state *> pi;

		// Tablica wszystkich wierzcholkow
		vector<state *> V;

		// Tablica haszujaca dla szybkiego wyszukiwania wierzcholkow
		vector<state *> hash_vertex;

		// Liczba miast ktore nalezy odwiedzic
		int cities_to_visit;

		void InitializeSingleSource(state *s);
		void Relax(state *u, state *v, int wuv);

		int to_int(int lt, int cot, int vc) {
			return(	lt +
				cot*(MAX_TICKETS+1) +
				vc*(MAX_TICKETS+1)*(MAX_CITIES+1));
			};
		int to_int(state *s) {return(to_int(s->last_ticket, s->city_on_ticket, s->visited_cities));};
		vector<state *> Path(state *s, state *v);
	public:
		graph(vector<pair<int, vector<int> > > tickets_vector, vector<int> vc);

		state *Dijkstra(state *s);
		void PrintTicketsPath(state *s, state *v);

		state *get_vertex(int lt, int cot, int vc);
		void create_edge(int lt1, int cot1, int vc1, int lt2, int cot2, int vc2, int len);

		bool is_unique();
};

state *graph::get_vertex(int lt, int cot, int vc)
{
	int v = to_int(lt, cot, vc);
	if(hash_vertex[v] == NIL)
	{
		state *s = new state(lt, cot, vc);
		V.push_back(s);
		hash_vertex[v] = s;
	}

	return hash_vertex[v];
}

void graph::create_edge(int lt1, int cot1, int vc1, int lt2, int cot2, int vc2, int len)
{
	state *s1 = get_vertex(lt1, cot1, vc1);
	state *s2 = get_vertex(lt2, cot2, vc2);
	s1->add_edge(s2, len);
}

void graph::PrintTicketsPath(state *s, state *v)
{
	vector<state *> path = Path(s, v);
	for(unsigned int i = 1; i < path.size(); ++i)
	{
		if(path[i - 1]->last_ticket != path[i]->last_ticket)
			cout << " " << path[i]->last_ticket;
	}
}

vector<state *> graph::Path(state *s, state *v)
{
	vector<state *> ret;
	if(v == s)
	{
		ret.push_back(s);
	} else if(pi[to_int(v)] == NIL) {
		cout << "nie ma sciezki\n";
	} else {
		ret = Path(s, pi[to_int(v)]);
		ret.push_back(v);
	}
	return ret;
}

void graph::InitializeSingleSource(state *s)
{
	for(vector<state *>::iterator it = V.begin(); it != V.end(); ++it)
	{
		(*it)->d = INF;
		pi[to_int(*it)] = NIL;
	}
	s->d = 0;
}

void graph::Relax(state *u, state *v, int wuv)
{
	if(v->d > u->d + wuv)
	{
		v->d = u->d + wuv;
		pi[to_int(v)] = u;
		// Tu moznaby przywrocic wlasnosc kopca
		// ale w mojej implementacji wyznaczam liniowo minimum, wiec nie musze.
	}
}


// Przydatny operator do wyciagania minimum z kopca
bool comparator(state *a, state *b)  {return (a->d < b->d);};

state *graph::Dijkstra(state *s)
{
	vector<state *> Q;

	for(vector<state *>::iterator it = V.begin(); it != V.end(); ++it)
		Q.push_back(*it);


	InitializeSingleSource(s);
	while(!Q.empty())
	{
		vector<state *>::iterator location = min_element(Q.begin(), Q.end(), comparator);
		state *u = *location;
		Q.erase(location);

		// Dodajemy wyniki zeby potem nie przeszukiwac wszystkiego
		if(u->visited_cities == cities_to_visit)
			return u;

		// graf nie musi byc spojny i wtedy jak dochodzimy do drugiej skladowej to mozna juz zakonczyc
		if(u->d == INF)
			break;

		for(unsigned int j = 0; j < u->adj.size(); ++j)
			Relax(u, u->adj[j].first, u->adj[j].second);
	}

	return NIL;
}

graph::graph(vector<pair<int, vector<int> > > tickets_vector, vector<int> vc)
{
	NIL = new state(-1, -1, -1);
	hash_vertex.resize((MAX_TICKETS+1)*(MAX_CITIES+1)*(MAX_CITIES_TO_VISIT+1), NIL);
	pi.resize((MAX_TICKETS+1)*(MAX_CITIES+1)*(MAX_CITIES_TO_VISIT+1), NIL);

	cities_to_visit = vc.size();

	// Tworzenie grafu
	for(unsigned int j = 0; j < tickets_vector.size(); ++j)
	{
		// Sytuacja: zaczynamy w (0, 0, 0) i bierzemy kolejny bilet
		// Jesli pierwsze miasto na bilecie zgadza sie z pierwszym miastem na trasie
		// Tworzymy w grafie krawedz miedzy stanem (0, 0, 0) a tym z jednym miastem z biletu
		if(vc[0] == tickets_vector[j].second[0])
		{
			// To idziemy do stanu w ktorym mamy juz jedno miasto odwiedzone
			create_edge(0, 0, 0, j+1, 0, 1, tickets_vector[j].first);
		} else
			// W przeciwnym przypadku nie mamy jeszcze miast odwiedzonych
			create_edge(0, 0, 0, j+1, 0, 0, tickets_vector[j].first);


		// tworzymy hipotetyczne wierzcholki i krawedzie
		// Zakladamy ze mamy juz jakies miasta odwiedzone i idziemy po kazdym bilecie
		// Pozniej beda powstawac polanczenia miedzy tymi "poziomami"
		// l - to liczba miast juz odwiedzonych
		for(unsigned int l = 0; l < vc.size(); ++l)
		{
			// Teraz przechodzimy po danym bilecie.
			// k - to numer miasta na j-tym bilecie
			for(unsigned int k = 1; k < tickets_vector[j].second.size(); ++k)
			{
				// I kontynuacja na tym samym bilecie
				int count = l;
				if(vc[l] == tickets_vector[j].second[k])
					count++;
					create_edge(j+1, k-1, l, j+1, k, count, 0);
			}
		}


		//kontynuacja na innym bilecie
		for(unsigned int l = 0; l < vc.size(); ++l)
		{
			for( unsigned int k = 0; k < tickets_vector[j].second.size(); ++k)
			{
				//kontynuacja na innym bilecie
				for(unsigned int m = 0; m < tickets_vector.size(); ++m)
					if(tickets_vector[j].second[k] == tickets_vector[m].second[0])
					{
						create_edge(j+1, k, l, m+1, 0, l, tickets_vector[m].first);
					}
			}
		}
	}
};

bool graph::is_unique()
{
	state *zero_state = get_vertex(0, 0, 0);

	state *e = Dijkstra(zero_state);
	int wyn = e->d;

	vector<state *> path = Path(zero_state, e);
	for(unsigned int i = 1; i < path.size(); ++i)
	{
		vector<pair<state *, int> > padj = path[i - 1]->adj;
		path[i - 1]->del_edge(path[i]);
		state *v = Dijkstra(zero_state);
		if(v != NIL && v->d == wyn)
		{
			cout << "Non Unique\n";
			return false;
		}

		path[i - 1]->adj = padj;
	}
	cout << "Qnique\n";
	return true;
}


// Glowna petla programu
int main_rec(int icase)
{
	vector<pair<int, vector<int> > > tickets_vector;

	int tickets;
	cin >> tickets;
	if(tickets == 0)
		return 0;

	// Na poczatku pobieramy bilety i zapamietujemy je bo bedziemy z nich korzystali
	// przy roznych podrozach
	for(int i = 0; i < tickets; ++i)
	{
		// wczytujemy koszt biletu
		int price;
		cin >> price;

		// Liczba miast na bilecie
		int cities;
		cin >> cities;

		// Wszytujemy miasta z biletu
		vector<int> cities_vector;
		for(int j = 0; j < cities; ++j)
		{
			int city;
			cin >> city;

			cities_vector.push_back(city);
		}

		tickets_vector.push_back(pair<int, vector<int> >(price, cities_vector));
	}

	int trips;
	cin >> trips;
	for(int i = 0; i < trips; ++i)
	{
		// Wczytujemy opis tracy
		// vc to vector miast na trasie, ktore musimy odwiedzic
		vector<int> vc;
		// n to liczba miast na trasie
		int n;
		cin >> n;
		for(int j = 0; j < n; ++j)
		{
			int c;
			cin >> c;
			vc.push_back(c);
		}

		graph g(tickets_vector, vc);

		state *zero_state = g.get_vertex(0, 0, 0);

		// Dijkstra zwraca nam wierzcholek, do ktorego doszlismy za najmniejsza cene
		state *e = g.Dijkstra(zero_state);

		cout << "Case " << icase << ", Trip " << i + 1 << ": Cost = " << e->d << "\n";
		cout << "  Tickets used:";
		// Z wektora pi[] otrzymujemy sciezke i uzyte bilety
		g.PrintTicketsPath(zero_state, e);
		cout << "\n";

//		g.is_unique();
	}

	return 1;
};


int main()
{
	int icase = 1;
	while(main_rec(icase++)){};
	return 0;
}
