#include <iostream>
#include <stdlib.h>
#include <stdio.h>

#define max_workshops 1000
#define max_rooms 1000
#define start_hour 14

using namespace std;

typedef struct {
 int part, dur;    // participants and duration
 bool nottaken;
} workshop;

typedef struct {
 int capac, time;  // capacity and time from 14:00 to the time the room must be cleared 
} room;


int compare(const void* a, const void* b)
{
	room* A = (room*) a;
	room* B = (room*) b;
	return A->time - B->time;
};



int main (int argc, char **argv){

int trial = 1, hlp, i, nW /* number of workshops */, nR /* number of rooms */;
int wLeft, pLeft;              // Number of tent-worshops and the number of their participants
workshop ws[max_workshops];    //  Avoiding numerous ...
room rm[max_rooms];            // ... memory allocations
char hour[5];                  // To read clearing times of particular rooms

fscanf(stdin, "%d", &hlp);

while (hlp)
 {
  pLeft = 0;
  for (i = 0; i < hlp; i++)    // storing information about WORKSHOPS 
   {
    fscanf(stdin, "%d", &(ws[i].part));
    fscanf(stdin, "%d", &(ws[i].dur));
    ws[i].nottaken = true;
    pLeft += ws[i].part;
   }
  wLeft = nW = hlp; 
   
  fscanf(stdin, "%d", &hlp);
  
  for (i = 0; i < hlp; i++)
   {
    fscanf(stdin, "%d", &(rm[i].capac));
    fscanf(stdin, "%s", hour);
    rm[i].time = 
    (((hour[0] - '0')*10 + hour[1] - '0') - start_hour)*60 + (hour[3] - '0')*10 + hour[4] - '0';
   }
  nR = hlp;

  /* THE MAIN PART */
  qsort(rm, nR, sizeof(room), compare);
  
  i = 0; int j, max;
  while ((wLeft > 0) && (i < nR))
   {
    max = hlp = -1;
    for (j = 0; j < nW; j++)
     if (ws[j].nottaken)
      if ((ws[j].dur <= rm[i].time) && (ws[j].part <= rm[i].capac))
        if (ws[j].part > max) {max = ws[j].part; hlp = j;}
    if (hlp != -1)
     {
      ws[hlp].nottaken = false;
      wLeft--;
      pLeft -= ws[hlp].part;
     }
    i++;
   }
  
  /* END OF THE MAIN PART */
  
  cout << "Trial " << trial << ":  " << wLeft << " " << pLeft << endl << endl;
  trial++;
  fscanf(stdin, "%d", &hlp);   // next trial's number of workshops or "terminating 0"
 }

return 0;
}
