import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Comparator;
import java.util.StringTokenizer;


class Workshop {
 int part, dur;    // participants and duration
 boolean nottaken;
};

class Room {
 int capac;
 int time;  // capacity and time from 14:00 to the time the room must be cleared
 boolean niezajety;
};

class WorkshopCmp<R> implements Comparator<R>
{
	public int compare(R o1, R o2)
	{
		Workshop r1 = (Workshop) o1;
		Workshop r2 = (Workshop) o2;
		return r2.part - r1.part;
	}
	public boolean equals(R o1, R o2)
	{
		return compare(o1, o2)  == 0;
	}
};

class RoomCmp<R> implements Comparator<R>
{
	public int compare(R o1, R o2)
	{
		Room r1 = (Room) o1;
		Room r2 = (Room) o2;
		return r1.time - r2.time;
	}
	public boolean equals(R o1, R o2)
	{
		return compare(o1, o2)  == 0;
	}
};


public class WorkshopsWer {
	static int max_workshops = 1000;
	static int max_rooms = 1000;
	static int start_hour = 14;
	public static void main(String[] args) throws Exception
	{

	int trial = 1, hlp, i, nW /* number of workshops */, nR /* number of rooms */;
	int wLeft, pLeft;              // Number of tent-worshops and the number of their participants
	Workshop ws[] = new Workshop[max_workshops];    //  Avoiding numerous ...
	for(int ii=0; ii<max_workshops; ii++)
		ws[ii] = new Workshop();
	Room rm[] = new Room[max_rooms];            // ... memory allocations
	for(int ii=0; ii<max_workshops; ii++)
		rm[ii] = new Room();
	String hour;                  // To read clearing times of particular rooms

	BufferedReader in = new BufferedReader(new InputStreamReader(System.in));

	String line = in.readLine();

	hlp = Integer.valueOf(line).intValue();


while (hlp != 0)
 {
  pLeft = 0;
  for (i = 0; i < hlp; i++)    // storing information about WORKSHOPS 
   {
    line = in.readLine();
    StringTokenizer st = new StringTokenizer(line);
   
    ws[i].part = Integer.valueOf(st.nextToken()).intValue();
    ws[i].dur  = Integer.valueOf(st.nextToken()).intValue();

    ws[i].nottaken = true;
    pLeft += ws[i].part;
   }
  wLeft = nW = hlp; 
  
  line = in.readLine();
  hlp  = Integer.valueOf(line).intValue();

  for (i = 0; i < hlp; i++)
   {
    line = in.readLine();
    StringTokenizer st = new StringTokenizer(line);
    rm[i].capac = Integer.valueOf(st.nextToken()).intValue();
    rm[i].niezajety = true;
    hour = st.nextToken();

    rm[i].time = 
    (((hour.charAt(0) - '0')*10 + hour.charAt(1) - '0') - start_hour)*60 + (hour.charAt(3) - '0')*10 + hour.charAt(4) - '0';
   }
  nR = hlp;

  
  
  int k;
 Arrays.sort(ws, new WorkshopCmp<Workshop>());
 for (i=0;i<nW; i++) {
	 k = -1;
	 int j;
	 int wolny = 600;
	 for(j=0;j<nR;j++) {
		 if ((rm[j].time<wolny)&&(rm[j].niezajety)&&(rm[j].time>=ws[i].dur) && (rm[j].capac>=ws[i].part)) {
			 wolny = rm[j].time;
			 k =j;
		 }
	}
	 if (k>=0) {
		 rm[k].niezajety = false;
		 pLeft = pLeft - ws[i].part;
		 wLeft--;
	 }
 }
  
  
  System.out.print("Trial " + new Integer(trial).toString() + ":  " + (new Integer(wLeft)).toString() + " " + (new Integer(pLeft)).toString() + "\n\n");
  
  trial++;

  line = in.readLine();

  hlp = Integer.valueOf(line).intValue(); // next trial's number of workshops or "terminating 0"
 }

}
}
