import java.util.*;
import java.io.*;
import java.lang.*;


class Workshop {
 int part, dur;    // participants and duration
 boolean nottaken;
};

class Room {
 int capac;
 int time;  // capacity and time from 14:00 to the time the room must be cleared 
};



class RoomCmp<R> implements Comparator<R>
{
	public int compare(R o1, R o2)
	{
		Room r1 = (Room) o1;
		Room r2 = (Room) o2;
		return r1.time - r2.time;
	}
	public boolean equals(R o1, R o2)
	{
		return compare(o1, o2)  == 0;
	}
};


public class Workshops {
	static int max_workshops = 1000;
	static int max_rooms = 1000;
	static int start_hour = 14;
	public static void main(String[] args) throws Exception
	{

	int trial = 1, hlp, i, nW /* number of workshops */, nR /* number of rooms */;
	int wLeft, pLeft;              // Number of tent-worshops and the number of their participants
	Workshop ws[] = new Workshop[max_workshops];    //  Avoiding numerous ...
	for(int ii=0; ii<max_workshops; ii++)
		ws[ii] = new Workshop();
	Room rm[] = new Room[max_rooms];            // ... memory allocations
	for(int ii=0; ii<max_workshops; ii++)
		rm[ii] = new Room();
	String hour;                  // To read clearing times of particular rooms

	BufferedReader in = new BufferedReader(new InputStreamReader(System.in));

	String line = in.readLine();

	hlp = Integer.valueOf(line).intValue();


while (hlp != 0)
 {
  pLeft = 0;
  for (i = 0; i < hlp; i++)    // storing information about WORKSHOPS 
   {
    line = in.readLine();
    StringTokenizer st = new StringTokenizer(line);
   
    ws[i].part = Integer.valueOf(st.nextToken()).intValue();
    ws[i].dur  = Integer.valueOf(st.nextToken()).intValue();

    ws[i].nottaken = true;
    pLeft += ws[i].part;
   }
  wLeft = nW = hlp; 
  
  line = in.readLine();
  hlp  = Integer.valueOf(line).intValue();

  for (i = 0; i < hlp; i++)
   {
    line = in.readLine();
    StringTokenizer st = new StringTokenizer(line);
    rm[i].capac = Integer.valueOf(st.nextToken()).intValue();
    hour = st.nextToken();

    rm[i].time = 
    (((hour.charAt(0) - '0')*10 + hour.charAt(1) - '0') - start_hour)*60 + (hour.charAt(3) - '0')*10 + hour.charAt(4) - '0';
   }
  nR = hlp;

  /* THE MAIN PART */
 // qusort(rm, 0, nR - 1);
 Arrays.sort(rm, new RoomCmp<Room>());
   // <do poprawy>
  i = 0; int j, max;
  while ((wLeft > 0) && (i < nR))
   {
    max = hlp = -1;
    for (j = 0; j < nW; j++)
     if (ws[j].nottaken)
      if ((ws[j].dur <= rm[i].time) && (ws[j].part <= rm[i].capac))
        if (ws[j].part > max) {max = ws[j].part; hlp = j;}
    if (hlp != -1)
     {
      ws[hlp].nottaken = false;
      wLeft--;
      pLeft -= ws[hlp].part;
     }
    i++;
   }
   // </do poprawy>  
  /* END OF THE MAIN PART */
  
  System.out.print("Trial " + new Integer(trial).toString() + ":  " + (new Integer(wLeft)).toString() + " " + (new Integer(pLeft)).toString() + "\n\n");
  
  trial++;

  line = in.readLine();

  hlp = Integer.valueOf(line).intValue(); // next trial's number of workshops or "terminating 0"
 }

}
}
