import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

import java.util.*;




public class ProblemH {
	static public class Pair{
		public int first;
		public int second;
		Pair(int x,int y){first =x;second=y;}
	}

	static public class PairComparator implements Comparator
	{
		 public int compare(Object a, Object b){
			Pair xa = (Pair)a;Pair xb = (Pair)b;
			if(xa.first < xb.first) return -1;
			else if(xa.first > xb.first) return 1;
			else {
				if(xa.second < xb.second) return -1;
				else if(xa.second > xb.second) return 1;
				else return 0;
			}
		}
		
	}

	static final int INF = 1000000;
	static final int MAX_N = 15;
	static final int MAX_DIST = 2 * MAX_N;

	static int board_size, result, test_no;
	static ArrayList stones = new ArrayList();

	/* returns distance beetween (x1,y1) and (x2, y2) */
	static int distance (int x1, int y1, int x2, int y2) {
		return Math.abs (x1 - x2) + Math.abs (y1 - y2);
	}


	/* returns minimal number of moves required
	 * to put all stones in one horizontal line */
	static int check_horizontal () {
		int moves_req = INF;
		for (int y = 1; y <= board_size; y++) {
			int dist = 0;
			for (int i = 0; i < board_size; i++) {
				dist += Math.abs (((Pair)stones.get(i)).second - y);
			}
			if (dist < moves_req)
				moves_req = dist;
		}
		Comparator c = new PairComparator();
		Collections.sort(stones,c); 
		
		//sort (stones.begin(), stones.end());
		for (int i = 0; i < board_size; i++) {
			moves_req += Math.abs (i + 1 - ((Pair)stones.get(i)).first);
		}
		return moves_req;
	}

	
	/* standard implementation of Hungarian Algorithm
	 * it takes matrix with weights and number of vertexes in each group;
	 * returns vector which shows the most expensive matching */
	static public int[] hungarian(int[][]  matrix, int n) {
		int[] lx = new int[n], ly = new int[n];
		int[] match_x = new int[n], match_y = new int[n], label_x = new int[n], label_y = new int[n];
		int[] slack = new int[n], nhbor = new int[n];
		ArrayList Q = new ArrayList();

		for (int i = 0; i < n; i++) {
			match_x[i] = -1;
			match_y[i] = -1;
			lx[i] = -INF;
			for(int j = 0;j<n;j++) if(matrix[i][j] > lx[i]) lx[i] = matrix[i][j]; 
			ly[i] = 0;
		}

		for (int step = 0; step < n; step++) {
			int augment = -1;
			Q.clear();
			for (int i = 0; i < n; i++) {
				label_x[i] = 0;
				label_y[i] = 0;
				slack[i] = INF;
				if (match_x[i] == -1)
					Q.add (new Integer(i));
			}
			while (augment == -1) {
				while (!Q.isEmpty() && augment == -1) {
					int v = ((Integer)Q.get(Q.size()-1)).intValue();
					Q.remove(Q.size()-1);
					label_x[v] = 1;
					for (int w = 0; w < n; w++) {
						if (label_y[w] == 0 && slack[w] > lx[v] + ly[w] - matrix[v][w]) {
							nhbor[w] = v;
							slack[w] = lx [v] + ly[w] - matrix[v][w];
							if (slack[w] == 0) {
								label_y[w] = 1;
								if (match_y[w] != -1)
									Q.add(new Integer(match_y[w]));
								else {
									augment = w;
									break;
								}
							}
						}
					}
				}
				if (augment == -1) {
					int e = INF;
					for (int i = 0; i < n; i++)
						if (label_y[i] == 0 && slack[i] < e)
							e = slack[i];
					for (int i = 0; i < n; i++) {
						if (label_x[i] == 1) lx[i] -= e;
						if (label_y[i] == 1) ly[i] += e;
						else {
							slack[i] -= e;
							if (slack[i] == 0) {
								label_y[i] = 1;
								if (match_y[i] != -1)
									Q.add (new Integer(match_y[i]));
								else
									augment = i;
							}
						}
					}
				}
			}
			while (augment != -1) {
				int tmp = match_x[nhbor[augment]];
				match_x[nhbor[augment]] = augment;
				match_y[augment] = nhbor[augment];
				augment = tmp;
			}
		}
		return match_x;
	}

	/* returns minimal number of moves required
	 * to put all stones in one diagonal line */
	static int check_diagonal () {
		/* preparing matrix for hungarian algorithm */
		int[][] matrix = new int[board_size][board_size];
		for (int i = 0; i < board_size; i++) {
			matrix[i] = new int[board_size];
		}
		for (int i = 0; i < board_size; i++) {
			for (int j = 0; j < board_size; j++) {
				matrix[i][j] = MAX_DIST - distance (((Pair)stones.get(i)).first, ((Pair)stones.get(i)).second, j+1, j+1);
			}
		}

		int[] matching = hungarian (matrix, board_size);
		int moves_req = 0;
		for (int i = 0; i < board_size; i++) {
			int s = matching[i] + 1;
			moves_req += distance (((Pair)stones.get(i)).first, ((Pair)stones.get(i)).second, s, s);
		}
		return moves_req;
	}
	
	public static void main(String[] args) {
		try{
		test_no = 1;
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        
		
		while (true) {
			StringTokenizer st = new StringTokenizer(in.readLine());
			board_size = Integer.parseInt(st.nextToken());
			if (board_size == 0) break;

			st = new StringTokenizer(in.readLine());
			for (int i = 0; i < board_size; i++) {
				int x,y;
				
				x = Integer.parseInt(st.nextToken());y=Integer.parseInt(st.nextToken());
				stones.add( new Pair(x, y));
			}

			/* checking horizontal lines */
			result = check_horizontal ();
			
			/* checking first diagonal */
			int diagonal = check_diagonal ();
			if (diagonal < result) result = diagonal;

			/* checking vertical lines 
			 * by rotating the board by 90 degrees
			 * and checking horizontal lines */
			for (int i = 0; i < board_size; i++) {
				int tmp = ((Pair)stones.get(i)).first;
				((Pair)stones.get(i)).first = ((Pair)stones.get(i)).second;
				((Pair)stones.get(i)).second = board_size + 1 - tmp;
			}
			int vertical = check_horizontal ();
			if (vertical < result) result = vertical;

			/* checking second diagonal
			 * by checking the first diagonal on rotated board */
			diagonal = check_diagonal ();
			if (diagonal < result) result = diagonal;

			System.out.println("Board "+String.valueOf(test_no)+": "+
					String.valueOf(result)+" moves required.\n\n");
			
			stones.clear();
			test_no++;
		}
		}catch (IOException e){
			e.printStackTrace();
		}
	}

	


}
