#include<cstdio>
#include<stdlib.h>
#include<vector>
#include<utility>
#include<algorithm>
using namespace std;

const int INF = 1000000;
const int MAX_N = 15;
const int MAX_DIST = 2 * MAX_N;

int board_size, result, test_no;
vector<pair<int, int> > stones;

/* returns distance beetween (x1,y1) and (x2, y2) */
int distance (int x1, int y1, int x2, int y2) {
	return abs (x1 - x2) + abs (y1 - y2);
}

/* returns minimal number of moves required
 * to put all stones in one horizontal line */
int check_horizontal () {
	int moves_req = INF;
	for (int y = 1; y <= board_size; y++) {
		int dist = 0;
		for (int i = 0; i < board_size; i++) {
			dist += abs (stones[i].second - y);
		}
		if (dist < moves_req)
			moves_req = dist;
	}
	sort (stones.begin(), stones.end());
	for (int i = 0; i < board_size; i++) {
		moves_req += abs (i + 1 - stones[i].first);
	}
	return moves_req;
}

/* standard implementation of Hungarian Algorithm
 * it takes matrix with weights and number of vertexes in each group;
 * returns vector which shows the most expensive matching */
vector<int> hungarian (int **matrix, int n) {
	int lx[n], ly[n];
	int match_x[n], match_y[n], label_x[n], label_y[n];
	int slack[n], nhbor[n];
	vector<int> Q;

	for (int i = 0; i < n; i++) {
		match_x[i] = -1;
		match_y[i] = -1;
		lx[i] = *max_element (matrix[i], matrix[i] + n);
		ly[i] = 0;
	}

	for (int step = 0; step < n; step++) {
		int augment = -1;
		Q.clear();
		for (int i = 0; i < n; i++) {
			label_x[i] = 0;
			label_y[i] = 0;
			slack[i] = INF;
			if (match_x[i] == -1)
				Q.push_back (i);
		}
		while (augment == -1) {
			while (!Q.empty() && augment == -1) {
				int v = Q.back();
				Q.pop_back();
				label_x[v] = 1;
				for (int w = 0; w < n; w++) {
					if (!label_y[w] && slack[w] > lx[v] + ly[w] - matrix[v][w]) {
						nhbor[w] = v;
						slack[w] = lx [v] + ly[w] - matrix[v][w];
						if (slack[w] == 0) {
							label_y[w] = 1;
							if (match_y[w] != -1)
								Q.push_back (match_y[w]);
							else {
								augment = w;
								break;
							}
						}
					}
				}
			}
			if (augment == -1) {
				int e = INF;
				for (int i = 0; i < n; i++)
					if (!label_y[i] && slack[i] < e)
						e = slack[i];
				for (int i = 0; i < n; i++) {
					if (label_x[i]) lx[i] -= e;
					if (label_y[i]) ly[i] += e;
					else {
						slack[i] -= e;
						if (slack[i] == 0) {
							label_y[i] = 1;
							if (match_y[i] != -1)
								Q.push_back (match_y[i]);
							else
								augment = i;
						}
					}
				}
			}
		}
		while (augment != -1) {
			int tmp = match_x[nhbor[augment]];
			match_x[nhbor[augment]] = augment;
			match_y[augment] = nhbor[augment];
			augment = tmp;
		}
	}
	return vector<int> (match_x, match_x + n);
}

/* returns minimal number of moves required
 * to put all stones in one diagonal line */
int check_diagonal () {
	/* preparing matrix for hungarian algorithm */
	int *matrix[MAX_N];
	for (int i = 0; i < board_size; i++) {
		matrix[i] = new int[board_size];
	}
	for (int i = 0; i < board_size; i++) {
		for (int j = 0; j < board_size; j++) {
			matrix[i][j] = MAX_DIST - distance (stones[i].first, stones[i].second, j+1, j+1);
		}
	}

	vector<int> matching = hungarian (matrix, board_size);
	int moves_req = 0;
	for (int i = 0; i < board_size; i++) {
		int s = matching[i] + 1;
		moves_req += distance (stones[i].first, stones[i].second, s, s);
	}
	return moves_req;
}

int main () {
	test_no = 1;
	while (true) {
		scanf ("%d", &board_size);
		if (!board_size) break;

		for (int i = 0; i < board_size; i++) {
			int x,y;
			scanf ("%d %d", &x, &y);
			stones.push_back (make_pair (x, y));
		}

		/* checking horizontal lines */
		result = check_horizontal ();
		
		/* checking first diagonal */
		int diagonal = check_diagonal ();
		if (diagonal < result) result = diagonal;

		/* checking vertical lines 
		 * by rotating the board by 90 degrees
		 * and checking horizontal lines */
		for (int i = 0; i < board_size; i++) {
			int tmp = stones[i].first;
			stones[i].first = stones[i].second;
			stones[i].second = board_size + 1 - tmp;
		}
		int vertical = check_horizontal ();
		if (vertical < result) result = vertical;

		/* checking second diagonal
		 * by checking the first diagonal on rotated board */
		diagonal = check_diagonal ();
		if (diagonal < result) result = diagonal;

		printf ("Board %d: %d moves required.\n\n", test_no, result);
		stones.clear();
		test_no++;
	}

	return 0;
}

