#include <iostream>
#include <list>
using namespace std;

void read();
bool eval();

int n;

int main() {
	int cnt = 0;
	cin >> n;
	while(n) {
		read();
		cout << "Polygon " << ++cnt << ": ";
		if(eval())
			cout << "Possible";
		else
			cout << "Impossible";
		cout << endl;
		cin >> n;
	}
	return 0;
}

#define Edge pair<char, int>

list<Edge> P;
int p_len;

void read() {
	p_len = 0;
	P.clear();
	for(int i = 0; i < n; ++i) {
		char dir;
		int len;
		cin >> dir >> len;
		P.push_back(make_pair(dir, len));
		p_len += len;
	}
}

list<Edge> fix(list<Edge> & LL) {
	list<Edge> L = LL;
	list<Edge>::iterator prev = L.begin(), pos = ++L.begin();
	while(pos != L.end()) {
		if(pos->first == prev->first) {
			prev->second += pos->second;
			pos = L.erase(pos);
		} else {
			++prev;
			++pos;
		}
	}
	int s = L.size();
	while(s > 1 && L.back().first == L.front().first) {
		L.front().second += L.back().second;
		L.erase(--L.end());
		--s;
	}
	return L;
}

list<Edge>::iterator next(list<Edge> & L, list<Edge>::iterator pos) {
	++pos;
	if(pos == L.end())
		return L.begin();
	return pos;
}

list<Edge>::iterator prev(list<Edge> & L, list<Edge>::iterator pos) {
	if(pos == L.begin())
		return --L.end();
	return --pos;
}

list<Edge>::iterator find_pole(list<Edge> & L, list<Edge>::iterator pos) {
	int togo = p_len/2;
	while(togo > 0) {
		togo -= pos->second;
		pos = next(L, pos);
	}
	if(togo < 0)
		return L.end();
	return pos;
}

list<Edge> get_path(list<Edge> & L, list<Edge>::iterator pos, int togo) {
	list<Edge> ret;
	while(togo > 0) {
		ret.push_back(make_pair(pos->first, min(pos->second, togo)));
		togo -= ret.back().second;
		pos = next(L, pos);
	}
	return ret;
}

list<Edge> get_rpath(list<Edge> & L, list<Edge>::iterator pos, int togo) {
	list<Edge> ret;
	while(togo > 0) {
		pos = prev(L, pos);
		ret.push_front(make_pair(pos->first, min(pos->second, togo)));
		togo -= ret.front().second;
	}
	return ret;
}

list<Edge> rev(list<Edge> L) {
	L.reverse();
	return L;
}

char neg_ch(char ch) {
	switch(ch) {
		case 'N':
			return 'S';
			break;
		case 'E':
			return 'W';
			break;
		case 'W':
			return 'E';
			break;
		case 'S':
			return 'N';
			break;
		default:
			return ch;
	}
}

list<Edge> neg(list<Edge> L) {
	list<Edge> ret;
	for(list<Edge>::iterator it = L.begin(); it != L.end(); ++it) {
		ret.push_back(make_pair(neg_ch(it->first), it->second));
	}
	return ret;
}

bool cyclic_equiv(list<Edge> str1, list<Edge> str2) {
	if(str1.size() != str2.size())
		return false;
	int n = str1.size();
	list<Edge>::iterator it = str1.begin(), jt = str2.begin();
	int i = 0, j = 0, k;
	while(i < n && j < n) {
		k = 0;
		while(k < n && *it == *jt) {
			++k;
			it = next(str1, it);
			jt = next(str2, jt);
		}
		if(k == n)
			return true;
		if(*it < *jt) {
			i += k+1;
			it = next(str1, it);
			continue;
		}
		if(*it > *jt) {
			j += k+1;
			jt = next(str2, jt);
			continue;
		}
	}
	return false;
}

bool eval() {
	P = fix(P);
	for(list<Edge>::iterator x1 = P.begin(); x1 != P.end(); ++x1) {
		list<Edge>::iterator x2 = find_pole(P, x1);
		if(x2 == P.end())
			continue;
		int len = 0;
		for(list<Edge>::iterator y1 = x1; y1 != x2; y1 = next(P, y1)) {
			list<Edge> x1y1, x2y2, y1x2, y2x1;
			x1y1 = get_path(P, x1, len);
			x2y2 = get_path(P, x2, len);
			y1x2 = get_path(P, y1, p_len/2 - len);
			y2x1 = get_rpath(P, x1, p_len/2 - len);
			if(x1y1 == neg(rev(x2y2))) {
				if(cyclic_equiv(fix(y1x2), fix(neg(rev(y2x1)))))
					return true;
			}
			len += y1->second;
		}
	}
	return false;
}
