
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.io.IOException;

public class g {

	static final int MAXN = 50;

	static int caseId;

	static int n;

	static int totalLength;

	static int half;

	static int[] length;

	static int[] dir;

	static int[] dist;

	static int[] aux1;

	static int[] aux2;

	static StreamTokenizer parser;

	static void init() {
		caseId = 1;
		length = new int[MAXN + 2];
		dir = new int[MAXN + 2];
		dist = new int[MAXN + 2];
		aux1 = new int[2 * MAXN + 4];
		aux2 = new int[2 * MAXN + 4];

		BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
		parser = new StreamTokenizer(r);
		parser.ordinaryChar('N');
		parser.ordinaryChar('E');
		parser.ordinaryChar('W');
		parser.ordinaryChar('S');
		parser.eolIsSignificant(false);
		parser.lowerCaseMode(false);
		parser.parseNumbers();
	}

	static boolean readPolygon() throws IOException {
		int i;

		parser.nextToken();
		n = (int) parser.nval;
		if (n == 0) {
			return false;
		}

		totalLength = 0;
		for (i = 0; i < n; i++) {
			parser.nextToken();
			dir[i] = parser.ttype;
			parser.nextToken();
			length[i] = (int) parser.nval;
			dist[i] = totalLength;
			totalLength += length[i];
		}
		dir[n] = 'E';
		length[n] = 0;
		dist[n] = totalLength;
		half = totalLength / 2;

		return true;
	}

	static int not(int dir) {
		switch (dir) {
		case 'N':
			return 'S';
		case 'E':
			return 'W';
		case 'W':
			return 'E';
		case 'S':
			return 'N';
		default:
			return 'X';
		}
	}

	static int extractRange(int from, int to, int[] aux) {
		int k, p1, p2;

		if (from == to)
			return 0;
		p1 = 0;
		while (dist[p1] < from)
			p1++;
		if (dist[p1] != from) p1--;
		p2 = 0;
		while (dist[p2] < to)
			p2++;
		if (dist[p2] != to)   p2--;  
		k = 0;
		if (dist[p1] != from) {
			k = 2;
			if ((p1 == p2) && (from <= to)) {
				aux[0] = dir[p1];
				aux[1] = to - from;
				return 2;
			}
			aux[0] = dir[p1];
			p1 = (p1 + 1) % n;
			aux[1] = p1 != 0 ? dist[p1] - from : totalLength - from;
		}
		if (p2 == n) p2 = 0;
		while (p1 != p2) {
			aux[k] = dir[p1];
			aux[k + 1] = length[p1];
			p1 = (p1 + 1) % n;
			k += 2;
		}
		if (dist[p2] != to) {
			aux[k] = dir[p2];
			aux[k + 1] = to - dist[p2];
			k += 2;
		}
		return k;
	}

	static void neg(int[] aux, int s) {
		int i;
		for (i = 0; i < s; i += 2) {
			aux[i] = not(aux[i]);
		}
	}

	static void rev(int[] aux, int l) {
		int i, t;
		for (i = 0; i < l / 2; i += 2) {
			t = aux[l - i - 2];
			aux[l - i - 2] = aux[i];
			aux[i] = t;
			t = aux[i + 1];
			aux[i + 1] = aux[l - i - 1];
			aux[l - i - 1] = t;
		}
	}

	static boolean cmp(int[] a1, int[] a2, int l) {
		int i;
		for (i = 0; i < l; i++) {
			if (a1[i] != a2[i]) {
				return false;
			}
		}
		return true;
	}

	static int fixAux(int[] aux, int l) {
		if (l == 0) {
			return 0;
		}
		if (aux[0] == aux[l - 2]) {
			aux[1] += aux[l - 1];
			return l - 2;
		} else {
			return l;
		}
	}

	private static boolean cyclicEquiv(int[] v1, int[] v2, int l) {
		int i, j, k;

		i = 0;
		j = 0;
		k = 0;
		while ((i < l) && (j < l)) {
			while (v1[(i + k) % l] == v2[(j + k) % l]) {
				k++;
				if (k == l)
					return true;
			}
			if (v1[i + k] > v2[j + k]) {
				i = i + k + 1;
			} else {
				j = j + k + 1;
			}
			k = 0;
		}
		return false;
	}

	static boolean check(int p1, int p2, int p3, int p4) {
		int l1 = extractRange(p1, p2, aux1);
		int l2 = extractRange(p3, p4, aux2);
		if (l1 != l2) {
			return false;
		}
		neg(aux2, l2);
		rev(aux2, l2);
		if (cmp(aux1, aux2, l1)) {
			l1 = extractRange(p2, p3, aux1);
			l2 = extractRange(p4, p1, aux2);
			l1 = fixAux(aux1, l1);
			l2 = fixAux(aux2, l2);
			if (l1 != l2) {
				return false;
			}
			neg(aux2, l2);
			rev(aux2, l2);
			return cyclicEquiv(aux1, aux2, l1);
		} else {
			return false;
		}
	}

	static boolean canTile() {
		int i, j, p1, p2, p3, p4;

		for (i = 0; i < n; i++) {
			for (j = 0; j < n; j++) {
				p1 = dist[i];
				p2 = dist[j];
				p3 = (dist[i] + half) % totalLength;
				p4 = (dist[j] + half) % totalLength;
				if (check(p1, p2, p3, p4) || check(p3, p2, p1, p4)
						|| check(p1, p4, p3, p2) || check(p3, p4, p1, p2)) {
					return true;
				}
			}
		}
		return false;
	}

	public static void main(String[] args) throws IOException {
		init();
		for (caseId = 1; readPolygon(); caseId++) {

			System.out.print("Polygon ");
			System.out.print(caseId);
			System.out.print(": ");
			if (canTile()) {
				System.out.println("Possible");
			} else {
				System.out.println("Impossible");
			}
		}
	}

}
