#include <limits.h>
#include <map>
#include <cstdio>
#include <queue>
#include <cstring>
#include <cstdio>
#include <iostream>
#include <assert.h>
#define POZ(x, y, sizex) (y*sizex + x)
#define MIN(x,y) (x<y?x:y)
#define MAX(x,y) (x<y?y:x)
using namespace std;


struct Node{
	int distance;
	int cost_left;
	int cost_right;
	int cost_up;
	int cost_down;
	bool done;
	Node():distance(2000000001), cost_left(0), cost_right(0), cost_up(0), cost_down(0), done(false){}

	bool operator<(const Node &b) const{
		if (distance < b.distance) return true;
		return false;
	}
};


struct Triple{
	int distance, x, y;
	Triple(int dist, int X, int Y):distance(dist), x(X), y(Y){}
	Triple(){}
};

class Priority_Queue{ //maximum difference between two elements in queue equals 1.
	int cur_distance;
	vector<Triple> *cur_vec; // vector of elements which distance (weight) is equal to cur_distance
	vector<Triple> *next_vec; // vector of elements which distance (weight) is bigger than cur_distance
	public:
		Priority_Queue():cur_distance(0),cur_vec(new vector<Triple>),next_vec (new vector<Triple>) {}
		
		void insert(Triple val){
			if (val.distance == cur_distance) cur_vec->push_back(val);
			else next_vec->push_back(val); // it means that val.distance = cur_distance + 1
		}

		bool extract_min(Triple &res){
			if (cur_vec->empty()) {
				free(cur_vec);
				cur_vec = next_vec;
				next_vec = new vector<Triple>;
				cur_distance++;
			}
			if (cur_vec->empty()) return false;
			res = cur_vec->back();
			cur_vec->pop_back();
			return true;
		}
};

struct Line{
	int x0, x1, y0, y1;	// coordinates given on input
	int x0c, x1c, y0c, y1c; // coordinates after compression
	bool vertical;
	Line(int xb, int xe, int yb, int ye): x0(xb), x1(xe), y0(yb), y1(ye), vertical(xb==xe?true:false) {}
};

struct To_sort{
	int value;	// value of coordinate to be sorted
	Line* line;	// line, which coordinate equals value
	bool if_home;	// true if value is a coordinate of home, false otherwise
	To_sort() {}
	To_sort(Line* lin, bool if_h, int val): value(val), line(lin), if_home(if_h) {}
	bool operator<(const To_sort &b) const{
		if (value < b.value) return true;
		return false;
	}
};

// coordinates compression
void convert(vector <To_sort> &xsorter, vector <To_sort> &ysorter, vector <Line*> &streets, int homex, int homey, int schoolx, int schooly, int &homexc, int &homeyc, int &schoolxc, int &schoolyc, int &sizex, int &sizey)
{
	Line *tmpline;
	vector <To_sort>::iterator its;
	sort(xsorter.begin(), xsorter.end());
	sort(ysorter.begin(), ysorter.end());
	int counter, val;
	counter = 1;
	its = xsorter.begin();
	if(its != xsorter.end())
		while(1){
			val = (*its).value;
			tmpline = (*its).line;
			if ((*its).line != NULL){
				if (tmpline->x0 == val) tmpline->x0c = counter;
				if (tmpline->x1 == val) tmpline->x1c = counter;
			}
			else{
				if ((*its).if_home) homexc = counter;
				else schoolxc = counter;
		}
		its++;
		if (its == xsorter.end()) break;
		if ((*its).value != val) counter++;
		}
	sizex = counter;
	
	counter = 1;
	its = ysorter.begin();
	
	if(its != ysorter.end())
		while(1){
			val = (*its).value;
			tmpline = (*its).line;

			if ((*its).line != NULL){
				if (tmpline->y0 == val) tmpline->y0c = counter;
				if (tmpline->y1 == val) tmpline->y1c = counter;
			}
			else{
				if ((*its).if_home) homeyc = counter;
				else schoolyc = counter;
			}
			
			its++;
			if (its == ysorter.end()) break;
			if ((*its).value != val) counter++;
		}
	sizey = counter;
}

// reading from input and converting streets coordinates
int read_streets(vector <Line*> &streets, int &homex, int &homey, int &schoolx, int &schooly, int &sizex, int &sizey)
{
	Line *tmpline;
	vector <To_sort> xsorter;
	vector <To_sort> ysorter;
	int number_of_streets, tmpx0, tmpx1, tmpy0, tmpy1;
	cin>>number_of_streets;
	if (number_of_streets == 0) return 0;

	for(int i = 0; i < number_of_streets; i ++){
		cin >> tmpx0 >> tmpy0 >> tmpx1 >> tmpy1;
		tmpline = new Line(tmpx0, tmpx1, tmpy0, tmpy1);
			
		xsorter.push_back (*(new To_sort(tmpline, false, tmpx0)));
		if (tmpx1 != tmpx0)
			xsorter.push_back (*(new To_sort (tmpline, false, tmpx1)));

		ysorter.push_back (*(new To_sort (tmpline, false, tmpy0)));
		if (tmpy1!=tmpy0)
			ysorter.push_back (*(new To_sort(tmpline, false, tmpy1)));
		streets.push_back(tmpline);
	}
	
	cin>>homex>>homey>>schoolx>>schooly;
	xsorter.push_back(*(new To_sort(NULL, true, homex)));
	ysorter.push_back(*(new To_sort(NULL, true, homey)));
	xsorter.push_back(*(new To_sort(NULL, false, schoolx)));
	ysorter.push_back(*(new To_sort(NULL, false, schooly)));
	convert(xsorter, ysorter, streets, homex, homey, schoolx, schooly, homex, homey, schoolx, schooly, sizex, sizey);

	return 1;
}

int relax(const Triple &triple, Priority_Queue &pq, Node city_map[], int sizex, int sizey){
	int x,y;
	x = triple.x;
	y = triple.y;
	fflush(stdout);
	if (city_map[POZ(x,y,sizex)].done) return 0;
	city_map[POZ(x,y,sizex)].done=true;
	if (x>0)
	if ((!city_map[POZ((x-1), y, sizex)].done) && 
	    (city_map[POZ((x-1),y, sizex)].distance)>triple.distance + city_map[POZ(x, y, sizex)].cost_left)
	{
		city_map[POZ((x-1),y, sizex)].distance=triple.distance+city_map[POZ(x,y,sizex)].cost_left;
		pq.insert(*(new Triple(city_map[POZ((x-1),y, sizex)].distance, x-1, y)));
	}
	if (y>0)
	if ((!city_map[POZ(x,(y-1),sizex)].done) && 
	(city_map[POZ(x,(y-1),sizex)].distance) > triple.distance+city_map[POZ(x,y,sizex)].cost_up)
	{	city_map[POZ(x,(y-1),sizex)].distance = triple.distance+city_map[POZ(x,y,sizex)].cost_up;
		pq.insert(*(new Triple(city_map[POZ(x,(y-1), sizex)].distance, x, y-1)));
	}
	if (x+1<sizex)
	if ((!city_map[POZ((x+1),	 y, sizex)].done) && 
	   (city_map[POZ((x+1),y, sizex)].distance)>triple.distance+city_map[POZ(x,y, sizex)].cost_right)
	{
		city_map[POZ((x+1),y, sizex)].distance=triple.distance+city_map[POZ(x,y, sizex)].cost_right;
		pq.insert(*(new Triple(city_map[POZ((x+1),y, sizex)].distance, x+1, y)));
	}
	if (y+1<sizey)
	if ((!city_map[POZ(x,(y+1),sizex)].done) && 
	    (city_map[POZ(x,(y+1),sizex)].distance) > triple.distance+city_map[POZ(x,y,sizex)].cost_down)
	{
		city_map[POZ(x,(y+1),sizex)].distance = triple.distance+city_map[POZ(x,y,sizex)].cost_down;
		pq.insert(*(new Triple(city_map[POZ(x,(y+1), sizex)].distance, x, y+1)));
	}
	return 0;
}

int main(){
	Node c;
	int homexc, homeyc, schoolxc, schoolyc, sizex, sizey;
	int city_number = 1;
	map <int, int> resize;
	vector <Line*> streets;
	vector <Line*>::iterator it;
 	Node *city_map;
	while (read_streets (streets, homexc, homeyc, schoolxc, schoolyc, sizex, sizey) != 0){
		sizex ++;
		sizey ++;
 		city_map = new Node[sizex*sizey];
		for (it=streets.begin(); it != streets.end(); it++) {
			if((**it).vertical){
				for (int i = MIN((**it).y0c, (**it).y1c); i<MAX((**it).y0c, (**it).y1c); i++)
				{
					city_map[ POZ((**it).x0c, i, sizex) ].cost_left = 1;
					city_map[ POZ(((**it).x0c)-1, i, sizex) ].cost_right = 1;
				}
			}
			else{
				
			for (int i = MIN((**it).x0c, (**it).x1c); i<MAX((**it).x0c, (**it).x1c); i++)
				{
					city_map[ POZ(i, (**it).y0c, sizex) ].cost_up = 1;
					city_map[ POZ(i, (((**it).y0c)-1), sizex) ].cost_down = 1;
				}
			}
		}
		city_map[POZ((homexc-1), (homeyc-1), sizex)].distance = 0;
		city_map[POZ((homexc), (homeyc-1), sizex)].distance = 0;
		city_map[POZ((homexc-1), (homeyc), sizex)].distance = 0;
		city_map[POZ((homexc), (homeyc), sizex)].distance = 0;
		Priority_Queue pq;
		pq.insert (*(new Triple(0, homexc-1, homeyc-1)));
		pq.insert (*(new Triple(0, homexc, homeyc-1)));
		pq.insert (*(new Triple(0, homexc-1, homeyc)));
		pq.insert (*(new Triple(0, homexc, homeyc)));
		Triple tmp;
		while(pq.extract_min(tmp)){
			relax(tmp, pq, city_map, sizex, sizey);
		}
		cout<<"City "<<city_number<<endl;
		cout<<"Peter has to cross "<< city_map[POZ(schoolxc, schoolyc, sizex)].distance<<" streets\n";
		city_number++;
		streets.clear();
		free(city_map);
	}
	return 0;
}
