package program_w_Javie;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.Vector;

/**
 * 
 * @author Micha Korch
 * 
 * The main class. For details see decsription of the algorythm that has been here used.
 *
 */
public class CrossingStreets {

	static public String IN = "streets7.in";
	static public String OUT = "streets7.out";
	static private int ileUlic;
	static private LinkedList<Street> listaUlic;
	static private LinkedList<Coordinate> lwx;
	static private LinkedList<Coordinate> lwy;
	static private Vector<Vector<Field>> graf;
	static private Point dom;
	static private Point uniwerek;
	static private int maxx;
	static private int maxy;
	
	public static void main(String args[]) {
		BufferedReader we;
		try {
			we = new BufferedReader(new FileReader(IN));
			PrintWriter wy;
			wy = new PrintWriter(new FileOutputStream(OUT));
			int nr =0;
			while (readIn(we)) {
				nr++;
				getXCoordinates();
				getYCoordinates();
				Coordinate[] ax = lwx.toArray(new Coordinate[0]);
				Coordinate[] ay = lwy.toArray(new Coordinate[0]);
				Arrays.sort(ax);
				Arrays.sort(ay);
				maxx = change(ax, lwx.size());
				maxy = change(ay, lwy.size());
				createGraph();
				dikstra();
				printOut(wy, nr);
			}
			we.close();
			wy.close();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	static private boolean readIn(BufferedReader we) throws IOException{
		ileUlic = Integer.parseInt(we.readLine());
		if (ileUlic == 0) {
			return false;
		} else {
			listaUlic = new LinkedList<Street>();
			int i;
			for (i=0;i<ileUlic;i++){
				Street ul = Street.wczytaj(we.readLine());
				listaUlic.add(ul);
			}
			StringTokenizer t = new StringTokenizer(we.readLine(), " ");
			long xd = Long.parseLong(t.nextToken());
			long yd = Long.parseLong(t.nextToken());
			long xu = Long.parseLong(t.nextToken());
			long yu = Long.parseLong(t.nextToken());
			dom = new Point(xd,yd);
			uniwerek = new Point(xu,yu);
			return true;
		}
	}
	
	static private void getXCoordinates(){
		lwx = new LinkedList<Coordinate>();
		Iterator it = listaUlic.iterator();
		Street ul;
		while(it.hasNext()) {
			ul = (Street) it.next();
			ul.addXCoordinates(lwx);
		}
		lwx.add(new PointCoordinate(PointCoordinate.PIERWSZA,dom));
		lwx.add(new PointCoordinate(PointCoordinate.PIERWSZA,uniwerek));
	}
	
	static private void getYCoordinates(){
		lwy = new LinkedList<Coordinate>();
		Iterator it = listaUlic.iterator();
		Street ul;
		while(it.hasNext()) {
			ul = (Street) it.next();
			ul.addYCoordinates(lwy);
		}
		lwy.add(new PointCoordinate(PointCoordinate.DRUGA,dom));
		lwy.add(new PointCoordinate(PointCoordinate.DRUGA,uniwerek));
	}
	
	static private int change(Coordinate[] a, int dl){
		int i;
		int j=-1;
		long k=-1;
		for (i=0;i<dl;i++) {
			if (k != a[i].getit()) {
				j++;
				k = a[i].getit();
			}
			a[i].changeTo(j);
		}
		return j;
	}
	
	static private void createGraph() {
		graf = new Vector<Vector<Field>>();
		int i,j;
		for (i=0;i<=maxx+1;i++) {
			Vector<Field> ity = new Vector<Field>();
			graf.addElement(ity);
			for (j=0;j<=maxy+1;j++) {
				ity.addElement(new Field(i,j));
			}
		}
		Iterator it = listaUlic.iterator();
		while(it.hasNext()) {
			((Street)it.next()).addYourselfToTheGraph(graf);
		}
	}
	
	static private void check(Field n, int d, SimpleHeap k, int m) {
		if (!n.in) {
			n.odl = d;
			k.insert(n,m);
		} else if (n.odl> d){
			n.odl = d;
			k.up_heap(n);
		}
	}
	
	static private void dikstra(){
		graf.get(dom.x).get(dom.y).odl=0;
		SimpleHeap k = new SimpleHeap();
		k.insert(graf.get(dom.x).get(dom.y),0);
		while(!(k.empty())) {
			Field p = (Field) k.delete_min();
			int d,m;
			Field n;
			if (p.x>0) {
				d = p.odl;
				if (p.l) {
					m = 1;
				} else {
					m = 0;
				}
				d = d + m;
				n = ((Field)((Vector)graf.get(p.x-1)).get(p.y));
				check(n,d,k,m);
			}
			if (p.x<maxx+1) {
				d = p.odl;
				if (p.p) {
					m = 1;
				} else {
					m = 0;
				}
				d = d + m;
				n = ((Field)((Vector)graf.get(p.x+1)).get(p.y));
				check(n,d,k,m);
			}
			if (p.y>0) {
				d = p.odl;
				if (p.g) {
					m = 1;
				} else {
					m = 0;
				}
				d = d + m;
				n = ((Field)((Vector)graf.get(p.x)).get(p.y-1));
				check(n,d,k,m);
			}
			if (p.y<maxy+1) {
				d = p.odl;
				if (p.d) {
					m = 1;
				} else {
					m = 0;
				}
				d = d + m;
				n = ((Field)((Vector)graf.get(p.x)).get(p.y+1));
				check(n,d,k,m);
			}
		}
	}
	
	static private void printOut(PrintWriter wy, int nr){
		wy.print("City ");
		wy.println(nr);
		wy.print("Peter has to cross ");
		wy.print(graf.get(uniwerek.x).get(uniwerek.y).odl);
		wy.println(" streets");
	}
	
}
