#include <cstdio>
#include <vector>
#include <algorithm>
#include <queue>
#define FOR(n) for (int i = 0; i < n; ++i)
#define FOR1(n,i) for (int i = 0; i < n; ++i)
#define FOLD(v) for (typeof(v.begin()) it = v.begin(); it != v.end(); ++it)
using namespace std;

// ACM2005, Zadanie F: "Crossing streets"
// Alternatywne rozwizanie wzorcowe, napisaa: Karolina Sotys

class area {
    public:
    bool left, right, up, down, visited;    
    area() {left = right = up = down = visited = false; }
};
class street {
    public:
    int x1, y1, x2, y2;
    street(int xx1, int yy1, int xx2, int yy2): x1(xx1),y1(yy1),x2(xx2),y2(yy2){}
};
class element {
    public:
    int key, link;
    element(int k, int l): key(k), link(l){}
    bool operator< (const element & other) const {
            return (key < other.key);
        }
};
class point {
    public:
    int x, y;
    point (int xx, int yy): x(xx), y(yy){}
    point (){};
    bool operator== (const point & other) const {
            return (x == other.x && y == other.y);
        }

};

vector <street> streets;
vector <element> crd_x, crd_y;
vector < vector <area> > town;
point peter, school;

void read_streets (int n) {
    int tx1, tx2, ty1, ty2;

    FOR(n) {
        scanf ("%d%d%d%d", &tx1, &ty1, &tx2, &ty2);
        streets.push_back (street (tx1, ty1, tx2, ty2));
        crd_x.push_back (element (tx1, i)); crd_y.push_back (element (ty1, i));
        crd_x.push_back (element (tx2, i)); crd_y.push_back (element (ty2, i));
    }
    scanf ("%d%d%d%d", &tx1, &ty1, &tx2, &ty2);
    peter = point(tx1, ty1);
    school = point(tx2, ty2);
    crd_x.push_back (element (tx1, n)); crd_y.push_back (element (ty1, n));
    crd_x.push_back (element (tx2, n+1)); crd_y.push_back (element (ty2, n+1));
}

int compress_x (int n) {
    int crd, compressed = 1;
    street * s;

    sort(crd_x.begin(), crd_x.end());
    crd = crd_x[0].key;
    FOLD(crd_x) {
        if (it->key > crd ) { crd = it->key; ++compressed; }
        if (it->link < n) {
            s = & streets[it->link];
            if ( s->x1 == crd ) s->x1 = compressed;
            if ( s->x2 == crd ) s->x2 = compressed;
        }
        else if (it->link == n) peter.x = compressed;
        else school.x = compressed;
    }
    return compressed + 1;
}

int compress_y (int n) {
    int crd, compressed = 1;
    street * s;

    sort(crd_y.begin(), crd_y.end());
    crd = crd_y[0].key;
    FOLD(crd_y) {
        if (it->key > crd ) { crd = it->key; ++compressed; }
        if (it->link < n) {
            s = & streets[it->link];
            if ( s->y1 == crd ) s->y1 = compressed;
            if ( s->y2 == crd ) s->y2 = compressed;
        }
        else if (it->link == n) peter.y = compressed;
        else school.y = compressed;
    }
    return compressed + 1;
}

void make_town (int size_x, int size_y) {
    town = vector < vector <area> > (size_y, vector <area> (size_x));
    FOLD(streets) {
        if (it->x1 == it->x2) {
            if (it->y1 < it->y2)
                for (int i = it->y1; i < it->y2; i++) {town[i][it->x1-1].right = true; town[i][it->x1].left = true; }
            else
                for (int i = it->y2; i < it->y1; i++) {town[i][it->x1-1].right = true; town[i][it->x1].left = true; }
        }
        else {
            if (it->x1 < it->x2)
                for (int i = it->x1; i < it->x2; i++) {town[it->y1-1][i].down = true; town[it->y1][i].up = true; }
            else
                for (int i = it->x2; i < it->x1; i++) {town[it->y1-1][i].down = true; town[it->y1][i].up = true; }

        }
    }
}

int dijkstra (int size_x, int size_y) {
	queue <point> q0, q1;
    point p;
	q0.push(peter);
	int steps = 0;

	while (1) {
		if (q0.empty()) {q0 = q1; q1 = queue <point>(); ++steps;}
		p = q0.front();
		q0.pop();
		if (town[p.y][p.x].visited == true) continue;
        town[p.y][p.x].visited = true;
		if (p==school) break;
		if (p.x > 0) {
			if (town[p.y][p.x].left == false) q0.push(point(p.x-1,p.y)); else q1.push(point(p.x-1,p.y)); }
		if (p.y > 0) {
			if (town[p.y][p.x].up == false) q0.push(point(p.x,p.y-1)); else q1.push(point(p.x,p.y-1)); }
		if (p.x < size_x-1) {
			if (town[p.y][p.x].right == false) q0.push(point(p.x+1,p.y)); else q1.push(point(p.x+1,p.y)); }
		if (p.y < size_y-1) {
			if (town[p.y][p.x].down == false) q0.push(point(p.x,p.y+1)); else q1.push(point(p.x,p.y+1)); }
	}
	return steps;
}

int main () {

    int n, count=0, size_x, size_y;

    while (1) {
        scanf ("%d", &n);
        if (n==0) break;
        streets=vector<street>(); crd_x=vector<element>(); crd_y=vector<element>();

        read_streets(n);
        size_x = compress_x(n);
        size_y = compress_y(n);
        make_town (size_x,size_y);

        printf ("City %d\nPeter has to cross %d streets\n", ++count, dijkstra(size_x, size_y) );
    }

    return 0;
}
