/*
 * Solution in C++ for problem E - Lots Of Sunlight 
 * ACM World Finals 2005
 * Author: Wojciech Czerwiski * 
 */
#include <cstdio>
#include <vector>
#include <cmath>

using namespace std;

typedef signed long long LL;

#define PI 3.1415926535
#define MAXN 100
#define REP(i,n) for(i=0;i<n;++i)
#define SUNRISE 20220
#define SUNSET 65820
#define MIDDAY (SUNRISE+SUNSET/2)
#define DEBUG(x) if(ON)x;
#define ON false

int n, w;
LL h;
LL high[MAXN]; // wysokosc budynku
LL xcoor[MAXN]; // x-owa wspolrzedna lewego brzegu budynku
vector<pair<LL,int> > elevels[MAXN]; // poziomy, na ktorych zaczynaja sie cienie ze wschodu
vector<pair<LL,int> > wlevels[MAXN]; // poziomy, na ktorych zaczynaja sie cienie z zachodu
char t[8];

bool read_data() {
	int i, m, d, actx;
	
	scanf("%d", &n);
	if (n == 0) return false;
	scanf("%d %lld", &w, &h);
	actx = 0;
	REP(i,n) {
		scanf( "%d", &m);
		high[i] = m*h;
		xcoor[i] = actx;
		if (i < n-1) {
			scanf( "%d", &d);
			actx += (d + w);
		}
	}
	return true;
}

bool test_pop(vector<int> buildings, int s, bool east, LL lastx, LL lasth) {
	int first, sec;
	LL firsth, firstx, sech, secx;
	first = buildings[s-2]; sec = buildings[s-1];
	firsth = high[first]; firstx = xcoor[first];
	sech = high[sec]; secx = xcoor[sec];
	if (east) {
		if ((lasth >= sech) || ((secx - firstx)*(sech - lasth) <= (firsth - sech)*(lastx - secx))) 
			return true;
		return false;
	} else {
		if ((lasth >= sech) || ((secx - firstx)*(sech - lasth) >= (firsth - sech)*(lastx - secx))) 
			return true;
		return false;		
	}
}

bool add_level(vector<int> buildings, int j, int i, bool east) {
	int first, sec;
	LL firsth, firstx, sech, secx, actx, reslev;
	double resh, fract;	
	int neww;
	
	if (east) neww = w; else neww = 0;
	// Porownuj budynek z nastepnym i patrz, gdzie trafia linia
	first = buildings[j]; sec = buildings[j+1];
	firsth = high[first]; firstx = xcoor[first]+neww;
	sech = high[sec]; secx = xcoor[sec]+neww;
	actx = xcoor[i]+(w-neww);
	fract = ((double)(actx - secx)/(double)(secx-firstx));
	resh = sech - fract*(firsth-sech);
	reslev = (LL) ceil(resh/h) + 1;
	// pietro, ktore juz nie jest zacienione przez ta linie
	if (reslev <= (high[i]/h)) {
		pair<LL,int> p(reslev,buildings[j]);
		// dla pietra reslev oraz wyzszych zacienia buildings[j]
		if (east) elevels[i].push_back(p);
		else wlevels[i].push_back(p);
		return true;
	} else return false;
}

void build_levels_east() {
	int i, s, first, sec, j;
	vector<int> buildings;
	LL lasth, lastx, firsth, firstx, sech, secx;
	LL thisx;
	
	REP(i,n) {
		if (i > 0) {
			// Zbuduj nowa - poprawna otoczke
			lasth = high[i-1];
			lastx = xcoor[i-1];
			s = buildings.size();
			while (s >= 2) {
				// Sprawdz, czy nie nalezy wywalic budynku z otoczki
				// jesli tak, to wywal
				if (test_pop(buildings, s, true, lastx, lasth)) buildings.pop_back();
				else break;
				s--;
			}
			// Jezeli jest tylko jeden budynek i nowy jest wyzszy, to stary wywalam
			if ((buildings.size() == 1) && (high[buildings[0]] <= high[i-1])) 
				buildings.pop_back();
			// Jezeli ostatni budynek rzuca na moj dol istotny cien, to go dodaje
			s = buildings.size();
			if (s <= 1) buildings.push_back(i-1);
			else {
				thisx = xcoor[i];
				first = buildings[s-2]; sec = buildings[s-1];
				firsth = high[first]; firstx = xcoor[first]+w;
				sech = high[sec]; secx = xcoor[sec]+w;
				if ((sech*(thisx-firstx)) > (firsth*(thisx-secx))) {
					buildings.push_back(i-1);
				};
			}
		}
		// Teraz zaznacz, gdzie rzucane sa cienie
		if (buildings.size() > 0) {
			pair<LL,int> recent(0,buildings[buildings.size()-1]);
			elevels[i].push_back(recent);
		}		
		for (j = (int) buildings.size()-2; j >= 0; --j) {
			if (!add_level(buildings, j, i, true)) break;
		}
	}
}

void build_levels_west() {
	int i, s, first, sec, j;
	vector<int> buildings;
	LL lasth, lastx, firsth, firstx, sech, secx;
	LL thisx;
	
	for (i = n-1; i >= 0; --i) {
		if (i < n-1) {
			// Zbuduj nowa - poprawna otoczke
			lasth = high[i+1];
			lastx = xcoor[i+1];
			s = buildings.size();
			while (s >= 2) {
				// Sprawdz, czy nie nalezy wywalic budynku z otoczki
				// jesli tak, to wywal
				if (test_pop(buildings, s, false, lastx, lasth)) buildings.pop_back();
				else break;
				s--;
			}
			// Jezeli jest tylko jeden budynek i nowy jest wyzszy, to stary wywalam
			if ((buildings.size() == 1) && (high[buildings[0]] <= high[i+1])) 
				buildings.pop_back();
			// Jezeli ostatni budynek rzuca na moj dol istotny cien, to go dodaje
			s = buildings.size();
			if (s <= 1) buildings.push_back(i+1);
			else {
				thisx = xcoor[i]+w;
				first = buildings[s-2]; sec = buildings[s-1];
				firsth = high[first]; firstx = xcoor[first];
				sech = high[sec]; secx = xcoor[sec];
				if ((sech*(firstx-thisx)) > (firsth*(secx-thisx))) {
					buildings.push_back(i+1);
				};
			}
		}	
		// Teraz zaznacz, gdzie rzucane sa cienie
		if (buildings.size() > 0) {
			pair<LL,int> recent(0,buildings[buildings.size()-1]);
			wlevels[i].push_back(recent);
		}		
		for (j = (int) buildings.size()-2; j >= 0; --j) {
			if(!add_level(buildings, j, i, false)) break;	
		}
	}	
}

char* print_time(int seconds) {
	int sec = seconds%60;
	int minutes = seconds/60;
	int min = minutes%60;
	int hours = minutes/60;

	t[0] = '0' + hours/10; t[1] = '0' + hours%10; t[2] = ':';
	t[3] = '0' + min/10; t[4] = '0' + min%10; t[5] = ':';
	t[6] = '0' + sec/10; t[7] = '0' + sec%10;
	return t;
}

void answer_query(LL q) {
	int l, r, m, eseconds, wseconds;
	int resbuild, build = ((int) q%100) - 1;
	LL level = q/100, mlevel;
	LL xdist, ydist;
	vector<pair<LL,int> > lev;
	double aftersunrise, beforesunset, esec, wsec;
	int startsec, endsec;
	
	if ((build >= n) || (high[build] < level*h)) {
		printf("\nApartment %lld: Does not exist\n", q);
	} else {
		if (build == 0) startsec = SUNRISE;
		else {
			// Teraz wyszukuje binarnie dla wschodu
			l = 0; lev = elevels[build]; r = lev.size()-1;
			while (l<r) {
				m = (l+r+1)/2;
				mlevel = lev[m].first;
				if (mlevel <= level) l = m;
				else r = m-1; 
			}
			resbuild = lev[l].second;
			xdist = xcoor[build] - xcoor[resbuild] - w;
			ydist = high[resbuild] - h*(level-1);
			if (ydist<0) startsec = SUNRISE;
			else {
				aftersunrise = atan((double)ydist/(double)xdist);
				esec = aftersunrise*60.0*760.0/PI;
				eseconds = (int) floor(esec);
				startsec = SUNRISE + eseconds;
			}			
		}
		
		if (build == n-1) endsec = SUNSET;
		else {
			// Teraz wyszukuje binarnie dla zachodu
			l = 0; lev = wlevels[build]; r = lev.size()-1;
			while (l<r) {
				m = (l+r+1)/2;
				mlevel = lev[m].first;
				if (mlevel <= level) l = m;
				else r = m-1; 
			}
			resbuild = lev[l].second;
			xdist = xcoor[resbuild] - xcoor[build] - w;
			ydist = high[resbuild] - h*(level-1);
			if (ydist<0) endsec = SUNSET;
			else {			
				beforesunset = atan((double)ydist/(double)xdist);
				wsec = beforesunset*60.0*760.0/PI;
				wseconds = (int) ceil(wsec);
				endsec = SUNSET - wseconds;
			}
		}		
		printf("\nApartment %lld: %s - ", q, print_time(startsec));
		printf("%s\n", print_time(endsec));
	}
}

int main() {
	LL q;
	int i, ap = 1;
	// Kazda serie budynkow rozwazamy oddzielnie
	while (read_data()) {
		// Po wczytaniu danych nt budynkow budujemy struktury
		build_levels_east();
		build_levels_west();
		// Odpowiadamy na zapytania
		if (ap != 1) printf("\n");
		printf("Apartment Complex: %d\n", ap);
		do {
			scanf( "%lld", &q);
			if (q != 0) answer_query(q);
		} while (q != 0);
		REP(i,MAXN) {
			elevels[i].clear();
			wlevels[i].clear();
		}	
		ap++;
	}
	return 0;
}
