import java.io.*;
import java.util.*;
import java.lang.Math;

/**
 * Solution in Java for Problem E - Lots Of Sunlight
 * ACM 2005 World Finals 
 * @author Wojciech Czerwinski
 */
public class LotsOfSunlight {
	static public final int maxN = 100;
	static public final double pi = 3.1415926535;
	static public final int sunrise = 20220;
	static public final int sunset = 65820;
	static public final int midday = (sunrise+sunset)/2;
	
	static public long n, w, h;
	static public long[] high = new long[maxN];
	static public long[] xCoor = new long[maxN];
	
	private static class Pair {
		private long first;
		private int second;
		
		public Pair(long first, int second) {
			this.first = first;
			this.second = second;
		}
		
		public long getFirst() {
			return first;
		}
		
		public int getSecond() {
			return second;
		}
	}
	
	private static class Time {
		private int sec, min, hour;
		
		public Time(int seconds) {
			sec = seconds%60;
			int minutes = seconds/60;
			min = minutes%60;
			hour = minutes/60;
		}
		
		private String getPart(int part) {
			if (part >= 10) return (new Integer(part).toString());
			else return ("0" + (new Integer(part).toString()));
		}
		
		public String getTime() {
			StringBuffer res = new StringBuffer();
			res.append(getPart(hour)).append(":").append(getPart(min)).append(":").append(getPart(sec));
			return res.toString();
		}
	}
	
	static public Vector<Pair>[] eLevels, wLevels;
	
	static {
		eLevels = new Vector[maxN];
		wLevels = new Vector[maxN];
		int k;
		for (k = 0; k < maxN; k++) eLevels[k] = new Vector<Pair>();
		for (k = 0; k < maxN; k++) wLevels[k] = new Vector<Pair>();		
	}
	
	private static boolean testPop(Vector<Integer> buildings, int s, boolean east, long lastX, long lastH) {
		int first, sec;
		long firstH, firstX, secH, secX;
		first = buildings.elementAt(s-2); sec = buildings.elementAt(s-1);
		firstH = high[first]; firstX = xCoor[first];
		secH = high[sec]; secX = xCoor[sec];
		if (east) {
			if ((lastH >= secH) || ((secX - firstX)*(secH - lastH) <= (firstH - secH)*(lastX - secX))) 
				return true;
			return false;
		} else {
			if ((lastH >= secH) || ((secX - firstX)*(secH - lastH) >= (firstH - secH)*(lastX - secX))) 
				return true;
			return false;		
		}
	}	
	
	private static boolean addLevel(Vector<Integer> buildings, int j, int i, boolean east) {
		int first, sec;
		long firstH, firstX, secH, secX, actx, reslev;
		double resH, fract;	
		long newW;
		
		if (east) newW = w; else newW = 0;
		// Porownuj budynek z nastepnym i patrz, gdzie trafia linia
		first = buildings.elementAt(j); sec = buildings.elementAt(j+1);
		firstH = high[first]; firstX = xCoor[first]+newW;
		secH = high[sec]; secX = xCoor[sec]+newW;
		actx = xCoor[i]+(w-newW);
		fract = ((double)(actx - secX)/(double)(secX-firstX));
		resH = secH - fract*(firstH-secH);
		reslev = (long) Math.ceil(resH/h) + 1;
		// pietro, ktore juz nie jest zacienione przez ta linie
		if (reslev <= (high[i]/h)) {
			Pair p = new Pair(reslev,buildings.elementAt(j));
			// dla pietra reslev oraz wyzszych zacienia buildings[j]
			if (east) eLevels[i].add(p);
			else wLevels[i].add(p);
			return true;
		} else return false;
	}	
	
	private static void buildLevelsEast() {
		int i, s, first, sec, j;
		Vector<Integer> buildings = new Vector<Integer>();
		long lastH, lastX, firstH, firstX, secH, secX;
		long thisX;
		
		for (i = 0; i < n; ++i) {
			if (i > 0) {
				// Zbuduj nowa - poprawna otoczke
				lastH = high[i-1];
				lastX = xCoor[i-1];
				s = buildings.size();
				while (s >= 2) {
					// Sprawdz, czy nie nalezy wywalic budynku z otoczki
					// jesli tak, to wywal
					// TODO: Czy to dziala w czasie stalym??
					if (testPop(buildings, s, true, lastX, lastH)) buildings.removeElementAt(buildings.size()-1);
					else break;
					s--;
				}
				// Jezeli jest tylko jeden budynek i nowy jest wyzszy, to stary wywalam
				if ((buildings.size() == 1) && (high[buildings.elementAt(0)] <= high[i-1])) 
					buildings.removeElementAt(buildings.size()-1);
				// Jezeli ostatni budynek rzuca na moj dol istotny cien, to go dodaje
				s = buildings.size();
				if (s <= 1) buildings.add(i-1);
				else {
					thisX = xCoor[i];
					first = buildings.elementAt(s-2); sec = buildings.elementAt(s-1);
					firstH = high[first]; firstX = xCoor[first]+w;
					secH = high[sec]; secX = xCoor[sec]+w;
					if ((secH*(thisX-firstX)) > (firstH*(thisX-secX))) {
						buildings.add(i-1);
					};
				}
			}
			// Teraz zaznacz, gdzie rzucane sa cienie
			if (buildings.size() > 0) {
				Pair recent = new Pair(0,buildings.elementAt(buildings.size()-1));
				eLevels[i].add(recent);
			}			
			for (j = (int) buildings.size()-2; j >= 0; --j) {
				if (!addLevel(buildings, j, i, true)) break;
			}
		}		
	}
	
	private static void buildLevelsWest() {
		int i, s, first, sec, j;
		Vector<Integer> buildings = new Vector<Integer>();
		long lastH, lastX, firstH, firstX, secH, secX;
		long thisX;
		
		for (i = (int) n-1; i >= 0; --i) {
			if (i < n-1) {
				// Zbuduj nowa - poprawna otoczke
				lastH = high[i+1];
				lastX = xCoor[i+1];
				s = buildings.size();
				while (s >= 2) {
					// Sprawdz, czy nie nalezy wywalic budynku z otoczki
					// jesli tak, to wywal
					if (testPop(buildings, s, false, lastX, lastH)) buildings.removeElementAt(buildings.size()-1);
					else break;
					s--;
				}
				// Jezeli jest tylko jeden budynek i nowy jest wyzszy, to stary wywalam
				if ((buildings.size() == 1) && (high[buildings.elementAt(0)] <= high[i+1])) 
					buildings.removeElementAt(buildings.size()-1);
				// Jezeli ostatni budynek rzuca na moj dol istotny cien, to go dodaje
				s = buildings.size();
				if (s <= 1) buildings.add(i+1);
				else {
					thisX = xCoor[i]+w;
					first = buildings.elementAt(s-2); sec = buildings.elementAt(s-1);
					firstH = high[first]; firstX = xCoor[first];
					secH = high[sec]; secX = xCoor[sec];
					if ((secH*(firstX-thisX)) > (firstH*(secX-thisX))) {
						buildings.add(i+1);
					};
				}
			}	
			// Teraz zaznacz, gdzie rzucane sa cienie
			if (buildings.size() > 0) {
				Pair recent = new Pair(0,buildings.elementAt(buildings.size()-1));
				wLevels[i].add(recent);
			}			
			for (j = (int) buildings.size()-2; j >= 0; --j) {
				if(!addLevel(buildings, j, i, false)) break;	
			}
		}	
	}	
	
	private static void answerQuery(long q) {
		int l, r, m, eSeconds, wSeconds;
		int resBuild, build = ((int) q%100) - 1;
		long level = q/100, mLevel;
		long xDist, yDist;
		Vector<Pair> lev;
		double afterSunrise, beforeSunset, eSec, wSec;
		int startSec, endSec;
		Time start, end;
		
		if ((build >= n) || (high[build] < level*h)) {
			System.out.println("\nApartment " + q + ": Does not exist");
		} else {
			if (build == 0) startSec = sunrise;
			else {
				// Teraz wyszukuje binarnie dla wschodu
				l = 0; lev = eLevels[build]; r = lev.size()-1;
				while (l<r) {
					m = (l+r+1)/2;
					mLevel = lev.elementAt(m).getFirst();
					if (mLevel <= level) l = m;
					else r = m-1; 
				}
				resBuild = lev.elementAt(l).getSecond();
				xDist = xCoor[build] - xCoor[resBuild] - w;
				yDist = high[resBuild] - h*(level-1);
				if (yDist<0) startSec = sunrise;
				else {
					afterSunrise = Math.atan((double)yDist/(double)xDist);
					eSec = afterSunrise*60.0*760.0/pi;
					eSeconds = (int) Math.floor(eSec);
					startSec = sunrise + eSeconds;
				}			
			}
			
			if (build == n-1) endSec = sunset;
			else {
				// Teraz wyszukuje binarnie dla zachodu
				l = 0; lev = wLevels[build]; r = lev.size()-1;
				while (l<r) {
					m = (l+r+1)/2;
					mLevel = lev.elementAt(m).getFirst();
					if (mLevel <= level) l = m;
					else r = m-1; 
				}
				resBuild = lev.elementAt(l).getSecond();
				xDist = xCoor[resBuild] - xCoor[build] - w;
				yDist = high[resBuild] - h*(level-1);
				if (yDist<0) endSec = sunset;
				else {			
					beforeSunset = Math.atan((double)yDist/(double)xDist);
					wSec = beforeSunset*60.0*760.0/pi;
					wSeconds = (int) Math.ceil(wSec);
					endSec = sunset - wSeconds;
				}
			}		
			start = new Time(startSec); end = new Time(endSec);
			System.out.println("\nApartment " + q + ": " + start.getTime() + " - " + end.getTime());
		}
	}	
	
	public static void main(String args[]) throws IOException {
		BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
		StringTokenizer secLine, thirdLine, queryLine;
		long xc, m, d, q;
		int ap = 1, i;
		
		// Kazda serie budynkow rozwazamy oddzielnie		
		while (true) {
			// Wczytujemy z wejscia dane
			n = Long.parseLong(new StringTokenizer(br.readLine()).nextToken());
			if (n == 0) break;				
			secLine = new StringTokenizer(br.readLine());
			w = Long.parseLong(secLine.nextToken());
			h = Long.parseLong(secLine.nextToken());
			xc = 0;
			thirdLine = new StringTokenizer(br.readLine());
			for (i = 0; i < n; i++) {
				m = Long.parseLong(thirdLine.nextToken());
				high[i] = m*h;
				xCoor[i] = xc;
				if (i != n-1) {
					d = Long.parseLong(thirdLine.nextToken());
					xc += (d + w);
				}
			}
			// Po wczytaniu danych nt budynkow budujemy struktury			
			buildLevelsEast();
			buildLevelsWest();
			// Odpowiadamy na zapytania
			if (ap != 1) System.out.println();
			System.out.println("Apartment Complex: " + ap);
			queryLine = new StringTokenizer(br.readLine());
			while (true) {
				q = Long.parseLong(queryLine.nextToken());
				if (q == 0) break;
				else answerQuery(q);				
			}
			// Czyscimy wektory przed nastepna seria zapytan
			for (i = 0; i < n; i++) {
				eLevels[i].clear();
				wLevels[i].clear();
			}
			ap++;
		}				
	}
}
