type tDenote = 
  | Den_none
(* _  (_, _)  *)
  | Den_one of int
(* x *)
  | Den_prod of (int * tDenote) list;;
(* (_, x, (_, _), (y, z)) *)

type tVal_prim = Primitives.tVal_prim;;
type tFun_prim =  int * Primitives.tVal_prim list * Primitives.tFun_prim;;

type tValue =
  | Val_prim  of tVal_prim
    (* wartosc prymitywna *)
  | Fun_prim  of tFun_prim
    (* funkcja prymitywna *)
  | Val_oper  of tValue * Primitives.tOper_prim * tValue
    (* operator primitywny *)
  | Val_if    of tValue * tValue * tValue
    (* warunek * if_true * if_false *)
  | Val_raise
    (* raise *)
  | Val_match of tValue * tDenote array * tValue array
    (* wartosc * denotations * values *)
  | Val_fappl of tValue * tValue
    (* function * argument *)
  | Val_cappl of (int * string) * tValue
    (* konstruktor * wyliczony argument *)
  | Val_fun   of tDenote * tValue
    (* denote * cialo *)
  | Val_rec   of tValue
    (* Y ( val ) *)
  | Val_ident of int
    (* numer id *)
  | Val_cons  of int * string
    (* numer cons * nazwa *)
  | Val_ref   of tValue
    (* ref do wartosci *)
  | Val_prod  of tValue array;;
    (* produkt w tabeli *)

type tEnvi = (string * tValue) list;;

val str_of_value : tValue -> string;;

val make : Semantic.tEnvi -> tEnvi;;
val run : tEnvi -> tValue;;