type tName = string;;

type tPoly_appl = tType_cons list option

and tType_cons =
  | Type_inny of tName * tPoly_appl
  | Type_prod of tType_cons list
  | Type_fun  of tType_cons * tType_cons;;

type tPoly_args = tName list;;

type tCons_cons =
  tName * tType_cons;;

type  tType_def = 
    Type_simp of tType_cons
  | Type_alg  of tCons_cons list

type tDen_arg =
  | Den_arg of tName
  | Den_none
  | Den_unit
  | Den_prod of tDen_arg list;;

type  tExpr =
  | Expr_prim   of Primitives.tVal_prim
  | Expr_oper   of tExpr * Primitives.tOper_prim * tExpr
  | Expr_if     of tExpr * tExpr * tExpr
  | Expr_match  of tExpr * (tName * tDen_arg * tExpr) list
  | Expr_appl   of tExpr * tExpr
  | Expr_fun    of tDen_arg * tType_cons * tExpr
  | Expr_name   of tName * tPoly_appl
  | Expr_prod   of tExpr list
  | Expr_letin  of tDen_arg * tExpr * tExpr;;

type tDef = 
  | Type_def of tType_def
  | Val_def  of tType_cons option * tExpr
  | Rec_def  of tName * tType_cons * tExpr;;

type tFile = (tName * tPoly_args * tDef) list;;