(* typ *)
type tType =
  | Type_prim     of Primitives.tType_prim
  | Type_prod     of tType list
  | Type_fun      of tType * tType
  | Type_alg      of string * tType list * (string list)
  | Type_poly_alg of string * (string list)
  | Type_ident    of string;;

(* poly type args *)
type tDen_typ = string list;;

(* poly type *)
type tPoly_type = tDen_typ * tType;;

(* konstruktor w algebrze *)
type tCons = string * int * tPoly_type;;
(* nazwa * numer * typ *)

(* identyfikator *)
type tIdent = string * int * tType;;
(* nazwa * numer * typ *)

type tDenote =
  | Den_none
  | Den_unit
  | Den_ident of tIdent
  | Den_prod of tDenote list;;

(* czyste wyrazenie - bez typu *)
type tExpr =
  | Expr_val_prim  of Primitives.tVal_prim
  | Expr_fun_prim  of int * Primitives.tVal_prim list * Primitives.tFun_prim
  | Expr_oper_prim of tExpr * Primitives.tOper_prim * tExpr
  | Expr_if        of tExpr * tExpr * tExpr
  | Expr_raise
  | Expr_match     of tExpr * (tCons * tDenote * tExpr) list
  | Expr_appl      of tExpr * tExpr
  | Expr_fun       of tDenote * tExpr
  | Expr_rec       of tExpr
  | Expr_ident     of tIdent
  | Expr_cons      of tCons
  | Expr_ref       of string
  | Expr_prod      of tExpr list
  | Expr_letin     of tDenote * tExpr * tExpr

exception Semantic_error   of string

exception Ident_error      of string * string * string
exception Ident_error_pure of string * string
(* tytul * ident *)

exception SType_error      of string * tType * string
exception SType_error_pure of string * tType
(* tytul * typ *)

exception Type_error      of string * tType * tType * string
exception Type_error_pure of string * tType * tType
(* tytul * typ * typ *)

(* ========================================================================== *)


type tEnvi;;

val str_of_type : tType -> string;;

val str_of_poly_args : tDen_typ -> string;;

val get_values : tEnvi -> (string * (tExpr * tPoly_type * bool)) list;;

val init : unit -> unit;;

val add : in_channel -> unit;;

val stop : unit -> tEnvi;;