exception Error of string;;
exception Run_time_error of string;;

(* operator prymitywny *)
type tOper_prim =
  | Op_equal
  | Op_scolon
  | Op_ge
  | Op_le
  | Op_geq
  | Op_leq
  | Op_neq
  | Op_or
  | Op_and
  | Op_xor
  | Op_add
  | Op_sub
  | Op_mul
  | Op_div
  | Op_mod
  | Op_pow;;

(* typ prymitywny *)
type tType_prim =
  | TP_unit
  | TP_bool
  | TP_int
  | TP_rat
  | TP_char
  | TP_str;;

(* wartosc prymitywna *)
type tVal_prim =
  | VP_unit
  | VP_bool of bool
  | VP_int of Big_int.big_int
  | VP_rat of Num.num
  | VP_char of char
  | VP_str of string;;

(* funkcja prymitywna *)
type tFun_prim = tVal_prim list -> tVal_prim;;

(* ========================================================================== *)

val act_file_name : string ref;;

val show_full_val_info : bool ref;;

val show_result_val : bool ref;;

val show_time : bool ref;;

(* ========================================================================== *)

val print_error : string -> unit;;
val print_runtime : string -> unit;;

val str_of_type : tType_prim -> string;;
val str_of_val : tVal_prim -> string;;

val compare : tVal_prim -> tVal_prim -> int;;

val unit: tVal_prim;;
val zero: tVal_prim;;

val get_op : string -> tOper_prim;;

val int_of_str : string -> tVal_prim;;
val rat_of_str : string -> tVal_prim;;
val char_of_char : char -> tVal_prim;;
val str_of_str : string -> tVal_prim;;

val get_type : tVal_prim -> tType_prim;;

val all_prim_funs : (string * (tFun_prim * tType_prim list)) list;;
val all_prim_vals : (string * (tVal_prim * tType_prim)) list;;
val all_prim_typs : (string * tType_prim) list;;
