%{
  open Syntax_tree;;
  open Primitives;;
%}

%token LPAREN RPAREN
%token LBRACKET RBRACKET
%token BAR
%token COMMA
%token SCOLON
%token SCOLON2
%token COLON
%token UNDER
%token EQUAL
%token <string> OP_COMP
%token <string> OP_LOG
%token <string> OP_ARL
%token <string> OP_ARH
%token STAR
%token ARROW
%token AARROW
%token <string> NAME
%token <string> INT
%token <string> RAT
%token <char> CHAR
%token <string> STRING
%token TYPE
%token MATCH
%token WITH
%token FUN
%token LET
%token REC
%token IN
%token IF
%token THEN
%token ELSE
%token EOF

/* ================================ */

%nonassoc LET REC IN
%nonassoc MATCH WITH
%left     BAR
%nonassoc FUN ARROW
%nonassoc IF THEN ELSE
%left     COMMA

%left     SCOLON

%left     OP_LOG EQUAL
%left     OP_COMP
%left     OP_ARL

%left     OP_ARH STAR

%right    AARROW

%nonassoc NAME
%nonassoc INT
%nonassoc RAT
%nonassoc CHAR
%nonassoc STRING

%nonassoc LBRACKET
%nonassoc LPAREN

%left     APPL

%start main
%type <Syntax_tree.tFile> main
%%

main:
    EOF                                                 { [] }
  | definition SCOLON2 main                             { $1 :: $3 }
;
definition:
    type_def                                            { $1 }
  | val_def                                             { $1 }
  | rec_def                                             { $1 }
;
type_def:
    TYPE NAME poly_args EQUAL type_cons                 { ($2, $3, Type_def (Type_simp $5)) }
  | TYPE NAME poly_args EQUAL BAR cons_list             { ($2, $3, Type_def (Type_alg $6)) }
;
val_def:
    LET NAME poly_args COLON type_cons EQUAL expr       { ($2, $3, Val_def (Some $5, $7)) }
  | LET NAME poly_args EQUAL expr                       { ($2, $3, Val_def (None, $5)) }    
;      
rec_def:
    LET REC NAME poly_args COLON type_cons EQUAL expr   { ($3, $4, Rec_def ($3, $6, $8)) } 
;


poly_args:
    /* empty */                                         { [] }
  | LBRACKET RBRACKET                                   { [] }
  | LBRACKET NAME poly_args_list                        { $2 :: $3 }
;
poly_args_list:
    RBRACKET                                            { [] }
  | COMMA NAME poly_args_list                           { $2 :: $3 }
;


poly_appl:
    /* empty */                                         { None }
  | LBRACKET RBRACKET                                   { Some [] }
  | LBRACKET type_cons poly_appl_list                   { Some ($2 :: $3) }
;
poly_appl_list:
    RBRACKET                                            { [] }
  | COMMA type_cons poly_appl_list                      { $2 :: $3 }
;


type_cons:
    type_prod_or_simple                                 { $1 }
  | type_cons AARROW type_cons  %prec AARROW            { Type_fun ($1, $3) }
;
type_simple:
    NAME poly_appl                                      { Type_inny ($1, $2) }
  | LPAREN type_cons RPAREN                             { $2 }
;
type_prod_or_simple:
    type_simple                                         { $1 }
  | type_simple STAR type_prod                          { Type_prod ($1:: (List.rev $3)) }
;
type_prod:
    type_simple                                         { [$1] }
  | type_prod STAR type_simple                          { $3::$1 }
;


cons_list:
    one_cons BAR cons_list                              { $1::$3 }
  | one_cons                                            { [$1] }
;
one_cons:
    NAME COLON type_cons                                { ($1, $3) }
;


den_prod_list:      
    den_arg RPAREN                                      { [$1] }
  | den_arg COMMA den_prod_list                         { $1::$3 }
;
den_arg:
    UNDER                                               { Den_none }
  | NAME                                                { Den_arg $1 }
  | LPAREN RPAREN                                       { Den_unit }
  | LPAREN den_prod_list                                { Den_prod $2 }
;


cons_prod_list:
    expr RPAREN                                         { [$1] }
  | expr COMMA cons_prod_list                           { $1::$3 }
;


expr:
    NAME poly_appl                                      { Expr_name ($1, $2) }
  | LPAREN RPAREN                                       { Expr_prim (unit) }
  | INT                                                 { Expr_prim (int_of_str $1) }
  | RAT                                                 { Expr_prim (rat_of_str $1) }
  | CHAR                                                { Expr_prim (char_of_char $1) }
  | STRING                                              { Expr_prim (str_of_str $1) }

  | LPAREN cons_prod_list                               { Expr_prod $2 }
  | MATCH expr WITH BAR denote_match                    { Expr_match ($2, $5) }
  | IF expr THEN expr ELSE expr                         { Expr_if ($2, $4, $6) }   
  | expr expr                            %prec APPL     { Expr_appl ($1, $2) }
  | LET den_arg EQUAL expr IN expr                      { Expr_letin ($2,$4,$6) }
  | FUN den_arg COLON type_cons ARROW expr              { Expr_fun ($2, $4, $6) }

  | expr SCOLON expr                                    { Expr_oper ($1, Op_scolon, $3) }
  | expr EQUAL expr                                     { Expr_oper ($1, Op_equal, $3) }

  | expr OP_COMP expr                                   { Expr_oper ($1, get_op $2, $3) }
  | expr OP_LOG expr                                    { Expr_oper ($1, get_op $2, $3) }
  | expr OP_ARL expr                                    { Expr_oper ($1, get_op $2, $3) }
  | expr OP_ARH expr                                    { Expr_oper ($1, get_op $2, $3) }
  | expr STAR expr                                      { Expr_oper ($1, Op_mul, $3) }
;


denote_match:
    one_denote BAR denote_match                         { $1::$3 }
  | one_denote                           %prec WITH     { [$1] }
;
one_denote:
    NAME den_arg ARROW expr                             { ($1, $2, $4) }
;