{
  open Parser;;
  open Lexing;;

  let make_error lexbuf =
    let pos = lexbuf.Lexing.lex_curr_p in
    let line = pos.Lexing.pos_lnum in
    let char = pos.Lexing.pos_cnum-pos.Lexing.pos_bol in
      String.concat "" [
      "Syntax error, line ";
      string_of_int line;
      ", character ";
      string_of_int char;
      ".\n"];;

  let inc_line lexbuf =
    lexbuf.lex_curr_p <-
      { lexbuf.lex_curr_p with
        pos_lnum = lexbuf.lex_curr_p.pos_lnum + 1;
	pos_bol = lexbuf.lex_curr_p.pos_cnum;
      };;

  let act_line lexbuf =
    lexbuf.lex_curr_p.pos_lnum;;

  let soc c = String.make 1 c;;
}


rule token = parse
    '\n'             { inc_line lexbuf; token lexbuf }
  | [' ' '\t']       { token lexbuf }
  
  | "//" [^ '\n' ]*  { token lexbuf }
  | "(*"             { comment lexbuf; token lexbuf }
  
  | '('              { LPAREN }
  | ')'              { RPAREN }
  | '['              { LBRACKET }
  | ']'              { RBRACKET }
  
  | '|'              { BAR }
  | ','              { COMMA }
  | ':'              { COLON }
  | ";;"             { SCOLON2 }
  | ';'              { SCOLON }
  | '_'              { UNDER }
  
  | "="              { EQUAL }
  | ">"  as o        { OP_COMP (soc o) }
  | "<"  as o        { OP_COMP (soc o) }
  | ">=" as o        { OP_COMP o }
  | "<=" as o        { OP_COMP o }
  | "<>" as o        { OP_COMP o }
  
  | "||" as o        { OP_LOG o }
  | "&&" as o        { OP_LOG o }
  | "$$" as o        { OP_LOG o }
  
  | "+"  as o        { OP_ARL (soc o) }
  | "-"  as o        { OP_ARL (soc o) }
  | "*"              { STAR }  
  | "/"  as o        { OP_ARH (soc o) }
  | "%"  as o        { OP_ARH (soc o) }
  | "^"  as o        { OP_ARH (soc o) }
  
  | "->"             { ARROW }
  | "=>"             { AARROW }
  
  | "type"           { TYPE }
  | "match"          { MATCH }
  | "with"           { WITH }
  | "fun"            { FUN }
  | "let"            { LET }
  | "rec"            { REC }
  | "in"             { IN }
  | "if"             { IF }
  | "then"           { THEN }
  | "else"           { ELSE }
  
  | eof              { EOF }

  | ['-']? ['0' - '9']+ '/' ['0' - '9']+ as r
                     { RAT r }

  | ['-']? ['0' - '9']+ as i
                     { INT i }

  | "'" (_ as c) "'"
                     { CHAR c }

  | "\"" ( [^ '\"' ]* as s ) "\""
                     { STRING s }

  | ['A'-'Z' 'a'-'z'] ['A'-'Z' 'a'-'z' '0'-'9' '_'] * as n
                     { NAME n }

  | _                { raise (Primitives.Error (make_error lexbuf)) }

and comment = parse
    "*)"               { }
  | '\n'               { inc_line lexbuf; comment lexbuf }
  | eof                { }
  | _                  { comment lexbuf }