Random.self_init ();;

let stdlib = "stdlib/";;

let version =
"The FunAlg interpreter, version 1.22\n"^
"Copyright (C) 2007 Michal Skrzypczak\n"^
"This is free software. You may redistribute copies of it under the terms of\n"^
"the GNU General Public License <http://www.gnu.org/licenses/gpl.html>.\n"^
"There is NO WARRANTY, to the extent permitted by law.\n"

let open_file name =
  try
    open_in (stdlib ^ name)
  with
    Sys_error _ ->
    (
      try
        open_in name
      with
        Sys_error s ->
          print_string s;
          print_newline ();
          exit 0
    );;

let files = ref 0;;

let run_file name =
  Primitives.act_file_name := name;
  files := !files + 1;
  let chan_in = open_file name in
    Semantic.add chan_in;;
    
let show_all todo _ =
  Primitives.show_full_val_info := todo;;

let show_res todo _ =
  Primitives.show_result_val := todo;;
  
let show_time todo _ =
  Primitives.show_time := todo;;  
  
let show_version _ =
  print_string version;
  exit 0;;

let usage = "Usage: funalg [<options>] <file>...";;

let spec_list =
[
  ("-s", Arg.Unit (show_all false), "Disable full type-and-value print (default)");
  ("-S", Arg.Unit (show_all true), "Enable full type-and-value print");
  ("-p", Arg.Unit (show_res false), "Disable main () value print (default)");    
  ("-P", Arg.Unit (show_res true), "Enable main () value print");      
  ("-t", Arg.Unit (show_time false), "Disable work time print (default)");    
  ("-T", Arg.Unit (show_time true), "Enable work time print");        
  ("-v", Arg.Unit (show_version), "Print interpreter version and quit")  
];;

try
  Semantic.init ();
  Arg.parse spec_list run_file usage;
  if !files = 0 then
    Arg.usage spec_list usage
  else
    let semantic = Semantic.stop () in
    let treecode = Treecode.make semantic in
    let start_time = Sys.time () in
    flush stdout;
    let result = Treecode.run treecode in
    if !Primitives.show_result_val then
      print_string ("# main () = " ^ (Treecode.str_of_value result) ^ "\n");
    if !Primitives.show_time then
      print_string ("# " ^ string_of_float (Sys.time () -. start_time) ^ " sec\n")
with
| Primitives.Error s -> Primitives.print_error s
| Primitives.Run_time_error s -> Primitives.print_runtime s;;