# Covid-19 Analysis in United States

Project for Data analysis and visualization that shows statistics, trends and predictions for COVID-19 pandemic in the United States of America. 

This projects presents a comprehensive data analysis and visualization of COVID-19 infection and death rates, vaccination trends, hospitalization occupancy lockdown orders and economic indicators at both national and state levels. It also highlights the difference between forecasted infection rates and actual COVID-19 data.

## Included plots:

-  New weekly confirmed COVID-19 cases and deaths countrywide.
-  Total number of COVID-19-related deaths statewide.
-  Cumulative COVID-19 cases and deaths comparing the USA to other countries. 
-  COVID-19 vaccination trends (full, 1 dose, boosters) both country and statewide.
-  Weekly COVID-19 hospital admissions compared to weekly new cases.
-  COVID-19 related hospital vs ICU occupancy.
-  Statewide stay-at-home orders.
-  Cumulative COVID-19 cases in US colleges during the 2020/2021 academic year.
-  Forecasts of new cases vs actual data.
-  Economic indicators - unemployment rate, import/export prices.

## Data sources:

GitHub repositories:

    https://github.com/nytimes/covid-19-data
    https://github.com/owid/covid-19-data/tree/master/public/data/vaccinations
    https://github.com/google/dspl
    https://github.com/ryan-serpico/us-college-coordinates
    https://github.com/google/dspl/blob/master/samples/google/canonical/states.csv

Centers for Disease Control and Prevention:

    https://covid.cdc.gov/covid-data-tracker/#datatracker-home

Ballotpedia:

    https://ballotpedia.org/States_that_issued_lockdown_and_stay-at-home_orders_in_response_to_the_coronavirus_(COVID-19)_pandemic,_2020

Our World in Data:

    https://ourworldindata.org/coronavirus

## Installation:

```bash
git clone https://github.com/agatapaluch/covid19_USA.git
cd covid19_USA
```

