import pandas as pd
import matplotlib.pyplot as plt
import os
from matplotlib.ticker import MultipleLocator
from matplotlib.ticker import FuncFormatter
from matplotlib import rcParams # do ustawinea globalnej czcionki
import argparse

parser = argparse.ArgumentParser(description="Choose whether to display the plot (0) or save it to a file (1).")
parser.add_argument('action', type=int, choices=[0, 1], help="0 - display the plot, 1 - save to file")
args = parser.parse_args()


rcParams['font.family'] = 'Liberation Serif' 
rcParams['font.size'] = 13                    
rcParams['text.color'] = '#2C3E50' 

df_gdp = pd.read_csv("../csv/GDP-EUROPE.csv")
df_gdp = df_gdp.melt(
    id_vars=['Country Name', 'Country Code'],  
    value_vars=[str(year) for year in range(2000, 2024)],      
    var_name='year',                             
    value_name='GDP'                    
)

fig, ax = plt.subplots()


ax.set_title("GDP Trends During the COVID-19 Pandemic", fontsize=19)
ax.set_xlim([0, 23])

ax.set_xlabel('year', fontsize=16)
ax.set_ylabel('GDP', fontsize=16)

ax.set_facecolor('#EAF4FB')


ax.xaxis.set_major_locator(MultipleLocator(4))
ax.xaxis.set_minor_locator(MultipleLocator(2))

ax.yaxis.set_major_locator(MultipleLocator(100000000000))
ax.yaxis.set_minor_locator(MultipleLocator(50000000000))
ax.yaxis.set_major_formatter(FuncFormatter(lambda x, _: f'{int(x/1000000000)}mld')) 


ax.xaxis.grid(True,'minor', color='#FFFFFF', linewidth=0.5)
ax.yaxis.grid(True,'minor', color='#FFFFFF', linewidth=0.5)
ax.xaxis.grid(True,'major', color='#FFFFFF', linewidth=1)
ax.yaxis.grid(True,'major', color='#FFFFFF', linewidth=1)


ax.tick_params(axis='both', which='major', labelsize=12, color="#EAF4FB") 
ax.tick_params(axis='both', which='minor', labelsize=12, color="#EAF4FB")

for spine in ax.spines.values():
    spine.set_visible(False)

# Sweden
ax.plot(df_gdp['year'].unique(), df_gdp[df_gdp['Country Name'] == 'Sweden']['GDP'], label = "Sweden", color='#C0392B')

# Europe average
ax.plot(df_gdp['year'].unique(), df_gdp.groupby(by=['year'])['GDP'].mean(),label = "Europe avg", color='#F4D03F')

# Poland
ax.plot(df_gdp['year'].unique(), df_gdp[df_gdp['Country Name'] == 'Poland']['GDP'], label = "Poland", color='#2980B9')


ax.legend(loc='center left', bbox_to_anchor=(1, 0.5))
fig.savefig('../images/' + os.path.basename(os.path.splitext(__file__)[0] + '.png'),
                format='png', dpi=300, bbox_inches='tight', pad_inches=1.0)
