# -*- coding: utf-8 -*-
"""
Created on Sun May  4 16:10:53 2025

@author: glori
"""

import pandas as pd
import plotly.graph_objects as go

df = pd.read_csv("norway_covid_2020_2024.csv")
df['date'] = pd.to_datetime(df['date'])

cases_df = df[['date', 'new_cases', 'people_vaccinated', 'people_fully_vaccinated']].dropna()

fig1 = go.Figure()

fig1.add_trace(go.Scatter(
    x=cases_df['date'],
    y=cases_df['new_cases'],
    mode='lines',
    name='New Cases',
    line=dict(color='green')
))

fig1.add_trace(go.Scatter(
    x=cases_df['date'],
    y=cases_df['people_vaccinated'],
    mode='lines',
    name='Vaccinated (≥1 Dose)',
    line=dict(color='orange'),
    yaxis='y2'
))

fig1.add_trace(go.Scatter(
    x=cases_df['date'],
    y=cases_df['people_fully_vaccinated'],
    mode='lines',
    name='Fully Vaccinated',
    line=dict(color='blue'),
    yaxis='y2'
))

fig1.update_layout(
    title='COVID-19 in Norway: New Cases vs Vaccination Progress',
    xaxis_title='Date',
    yaxis=dict(
        title='New Cases',
        titlefont=dict(color='green'),
        tickfont=dict(color='green')
    ),
    yaxis2=dict(
        title='Vaccinated People',
        titlefont=dict(color='blue'),
        tickfont=dict(color='blue'),
        overlaying='y',
        side='right'
    ),
    template='plotly_dark'
)

fig1.write_html("new_cases_vs_vaccination_norway.html")

deaths_df = df[['date', 'total_deaths', 'people_vaccinated', 'people_fully_vaccinated']].dropna()

fig2 = go.Figure()

fig2.add_trace(go.Scatter(
    x=deaths_df['date'],
    y=deaths_df['total_deaths'],
    mode='lines',
    name='Total Deaths',
    line=dict(color='red')
))

fig2.add_trace(go.Scatter(
    x=deaths_df['date'],
    y=deaths_df['people_vaccinated'],
    mode='lines',
    name='Vaccinated (≥1 Dose)',
    line=dict(color='orange'),
    yaxis='y2'
))

fig2.add_trace(go.Scatter(
    x=deaths_df['date'],
    y=deaths_df['people_fully_vaccinated'],
    mode='lines',
    name='Fully Vaccinated',
    line=dict(color='blue'),
    yaxis='y2'
))

fig2.update_layout(
    title='COVID-19 in Norway: Total Deaths vs Vaccination Progress',
    xaxis_title='Date',
    yaxis=dict(
        title='Total Deaths',
        titlefont=dict(color='red'),
        tickfont=dict(color='red')
    ),
    yaxis2=dict(
        title='Vaccinated People',
        titlefont=dict(color='blue'),
        tickfont=dict(color='blue'),
        overlaying='y',
        side='right'
    ),
    template='plotly_dark'
)

fig2.write_html("deaths_vs_vaccination_norway.html")




