# -*- coding: utf-8 -*-
"""
Created on Sun May  4 16:10:53 2025

@author: glori
"""

import pandas as pd
import plotly.express as px
import plotly.graph_objects as go

df = pd.read_csv("brazil_covid.csv")
df['date'] = pd.to_datetime(df['date'])

df['vaccinated_pct'] = df['people_vaccinated'] / df['population'] * 100
df['fully_vaccinated_pct'] = df['people_fully_vaccinated'] / df['population'] * 100


vacc_df = df[['date', 'vaccinated_pct', 'fully_vaccinated_pct']].dropna()

fig = px.line(
    vacc_df,
    x='date',
    y=['vaccinated_pct', 'fully_vaccinated_pct'],
    labels={'value': 'Percent of Population', 'variable': 'Vaccination Status'},
    title='COVID-19 Vaccination Progress in Brazil (as % of Population)',
    template='plotly_dark'
)
fig.update_layout(legend_title_text='Vaccination Type')
fig.write_html("vaccination_progress_brazil_percent.html")
fig.show()

cases_df = df[['date', 'new_cases', 'vaccinated_pct', 'fully_vaccinated_pct']].dropna()

fig1 = go.Figure()

fig1.add_trace(go.Scatter(
    x=cases_df['date'],
    y=cases_df['new_cases'],
    mode='lines',
    name='New Cases',
    line=dict(color='green')
))

fig1.add_trace(go.Scatter(
    x=cases_df['date'],
    y=cases_df['vaccinated_pct'],
    mode='lines',
    name='Vaccinated (≥1 Dose, %)',
    line=dict(color='orange'),
    yaxis='y2'
))

fig1.add_trace(go.Scatter(
    x=cases_df['date'],
    y=cases_df['fully_vaccinated_pct'],
    mode='lines',
    name='Fully Vaccinated (%)',
    line=dict(color='blue'),
    yaxis='y2'
))

fig1.update_layout(
    title='COVID-19 in Brazil: New Cases vs Vaccination Progress (%)',
    xaxis_title='Date',
    yaxis=dict(
        title='New Cases',
        titlefont=dict(color='green'),
        tickfont=dict(color='green')
    ),
    yaxis2=dict(
        title='Vaccinated (% of Population)',
        titlefont=dict(color='blue'),
        tickfont=dict(color='blue'),
        overlaying='y',
        side='right'
    ),
    template='plotly_dark'
)
fig1.write_html("new_cases_vs_vaccination_brazil.html")
fig1.show()


deaths_df = df[['date', 'total_deaths', 'vaccinated_pct', 'fully_vaccinated_pct']].dropna()

fig2 = go.Figure()

fig2.add_trace(go.Scatter(
    x=deaths_df['date'],
    y=deaths_df['total_deaths'],
    mode='lines',
    name='Total Deaths',
    line=dict(color='red')
))

fig2.add_trace(go.Scatter(
    x=deaths_df['date'],
    y=deaths_df['vaccinated_pct'],
    mode='lines',
    name='Vaccinated (≥1 Dose, %)',
    line=dict(color='orange'),
    yaxis='y2'
))

fig2.add_trace(go.Scatter(
    x=deaths_df['date'],
    y=deaths_df['fully_vaccinated_pct'],
    mode='lines',
    name='Fully Vaccinated (%)',
    line=dict(color='blue'),
    yaxis='y2'
))

fig2.update_layout(
    title='COVID-19 in Brazil: Total Deaths vs Vaccination Progress (%)',
    xaxis_title='Date',
    yaxis=dict(
        title='Total Deaths',
        titlefont=dict(color='red'),
        tickfont=dict(color='red')
    ),
    yaxis2=dict(
        title='Vaccinated (% of Population)',
        titlefont=dict(color='blue'),
        tickfont=dict(color='blue'),
        overlaying='y',
        side='right'
    ),
    template='plotly_dark'
)
fig2.write_html("deaths_vs_vaccination_brazil.html")
fig2.show()





