import os

# Ruta donde están las gráficas
base_path = r"C:\Users\natal\Desktop\Varsovia\DAV\PROJECT"

# Lista completa de archivos: (nombre del archivo, título, descripción corta)
graphics = [
    # Primer grupo
    ("norway_milestones_with_cases.html", "COVID-19 Milestones and Cases in Norway", "Key pandemic events in Norway shown alongside case evolution."),
    ("norway_covid_cases_deaths.html", "COVID-19 Cases and Deaths", "This visualization illustrates the total number of COVID-19 cases and deaths recorded in Norway."),
    ("norway_covid_daily_cases_deaths.html", "Daily COVID-19 Cases and Deaths", "The graph displays the daily reported cases and deaths in Norway."),
    ("hospitalizations.html", "Hospitalizations Overview", "This interactive chart shows the number of hospitalizations due to COVID-19 over time in Norway."),
    ("casesvsrestrictions.html", "Cases vs Government Restrictions", "This chart compares COVID-19 case trends with the timeline of government restrictions."),
    ("diabetes_cardiovasc_deaths.png", "Deaths from Diabetes and Cardiovascular Diseases", "This image shows the trends of deaths related to diabetes and cardiovascular issues during the COVID-19 pandemic."),
    ("arima_forecast_2020_2022.png", "ARIMA Forecast (2020–2022)", "Forecast of COVID-19 cases using the ARIMA model for the years 2020 to 2022."),
    ("arima_forecast_2020_2021.png", "ARIMA Forecast (2020–2021)", "Forecast of COVID-19 cases using ARIMA for 2020–2021."),
    ("hwes_forecast_2023.png", "HWES Forecast (2023)", "Holt-Winters Exponential Smoothing forecast for COVID-19 cases in 2023."),
    ("hwes_forecast_2021.png", "HWES Forecast (2021)", "Forecast using HWES model for the year 2021."),
    ("hwes_forecast_2022.png", "HWES Forecast (2022)", "HWES model prediction for 2022."),

    # Nuevas gráficas añadidas
    ("deaths_vs_vaccination_norway.html", "Deaths vs Vaccination in Norway", "Correlation between vaccination levels and death rates in Norway."),
    ("new_cases_vs_vaccination_norway.html", "New Cases vs Vaccination in Norway", "Monitoring new case trends and vaccination efforts in Norway."),
    ("deaths_vs_vaccination_spain.html", "Deaths vs Vaccination in Spain", "Analysis of COVID-19 deaths and vaccination progression in Spain."),
    ("new_cases_vs_vaccination_spain.html", "New Cases vs Vaccination in Spain", "Comparison between new COVID-19 cases and vaccination rates in Spain."),
    ("deaths_vs_vaccination_brazil.html", "Deaths vs Vaccination in Brazil", "Relationship between deaths and vaccination in Brazil during the pandemic."),
    ("new_cases_vs_vaccination_brazil.html", "New Cases vs Vaccination in Brazil", "Visualization of Brazil’s vaccination efforts and their impact on case numbers."),
    ("bubble_vax_vs_deaths.html", "Bubble Chart: Vaccination vs Deaths", "A comparative bubble chart showing vaccination coverage and death rates."),
    ("daily_cases_toggle_multi.html", "Daily Cases by Country (Toggle View)", "Interactive multi-country chart showing daily cases with toggle functionality."),
    ("norway_radar.png", "Norway: COVID-19 Impact Radar", "Radar visualization of COVID-19 metrics in Norway."),
    ("sweden_radar.png", "Sweden: COVID-19 Impact Radar", "Radar chart displaying COVID-19 impact dimensions in Sweden."),
    ("finland_radar.png", "Finland: COVID-19 Impact Radar", "Radar chart of Finland's performance on various COVID-19 indicators.")
]

# Archivo de salida
output_file = os.path.join(base_path, "covid_norway_report.html")

# Plantilla base del HTML
html_template = """<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>COVID-19 in Norway - Data Analysis Report</title>
    <style>
        body {{ font-family: Arial, sans-serif; margin: 40px; background-color: #f9f9f9; }}
        h1, h2 {{ color: #333; }}
        section {{ margin-bottom: 50px; padding: 20px; background-color: #fff;
                  border-radius: 8px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); }}
        iframe, img {{ display: block; width: 100%; max-width: 900px; margin: 20px 0; border: none; }}
        img {{ height: auto; }}
    </style>
</head>
<body>
    <h1>COVID-19 in Norway: Data Analysis and Forecast</h1>
    {sections}
</body>
</html>
"""

# Generar secciones HTML por cada archivo
sections = ""
for filename, title, description in graphics:
    file_ext = os.path.splitext(filename)[1]
    full_path = filename
    if file_ext == ".html":
        content = f"""
        <section>
            <h2>{title}</h2>
            <p>{description}</p>
            <iframe src="{full_path}" height="500"></iframe>
        </section>
        """
    elif file_ext == ".png":
        content = f"""
        <section>
            <h2>{title}</h2>
            <p>{description}</p>
            <img src="{full_path}" alt="{title}">
        </section>
        """
    else:
        continue
    sections += content

# Escribir HTML final
with open(output_file, "w", encoding="utf-8") as f:
    f.write(html_template.format(sections=sections))

print(f"✅ Report generated successfully at: {output_file}")
