import pandas as pd
import plotly.graph_objs as go
from plotly.offline import plot

df = pd.read_excel("C:/Users/natal/Desktop/Varsovia/DAV/PROJECT/Antall innlagte med påvist covid-19.xlsx",skiprows="3")  # Asegúrate de que el archivo esté en el mismo directorio


df.columns = ["Date", "Total_Hospitalized", "ICU", "Invasive_Respiration"]

df = df[pd.to_datetime(df["Date"], errors='coerce').notna()]
df["Date"] = pd.to_datetime(df["Date"])

fig = go.Figure()

fig.add_trace(go.Scatter(
    x=df["Date"], y=df["Total_Hospitalized"],
    mode='lines+markers',
    name='Total Hospitalized'
))

fig.add_trace(go.Scatter(
    x=df["Date"], y=df["ICU"],
    mode='lines+markers',
    name='ICU'
))

fig.add_trace(go.Scatter(
    x=df["Date"], y=df["Invasive_Respiration"],
    mode='lines+markers',
    name='Invasive Respiration'
))

fig.update_layout(
    title="COVID-19 Hospitalizations in Norway",
    xaxis_title="Date",
    yaxis_title="Number of Patients",
    hovermode='x unified'
)

plot(fig)
