import pandas as pd
import matplotlib.pyplot as plt
import seaborn as sns
import glob

archivos = ['brazil_covid.csv', 'finland_covid.csv', 'india_covid.csv',
            'romania_covid.csv', 'south_korea_covid.csv', 'sweden_covid.csv', 'norway_covid_2020_2024.csv']

dfs = [pd.read_csv(archivo) for archivo in archivos]
df = pd.concat(dfs, ignore_index=True)

df['date'] = pd.to_datetime(df['date'])
latest_df = df.sort_values('date').groupby('location').last().reset_index()

filtered_df = latest_df[['location', 'diabetes_prevalence', 'cardiovasc_death_rate', 'total_deaths_per_million']].dropna()

# correlations
r_diabetes = filtered_df['diabetes_prevalence'].corr(filtered_df['total_deaths_per_million'])
r_cardio = filtered_df['cardiovasc_death_rate'].corr(filtered_df['total_deaths_per_million'])

sns.set(style='whitegrid')
fig, axes = plt.subplots(1, 2, figsize=(15, 6))

# Diabetes
sns.regplot(
    ax=axes[0],
    data=filtered_df,
    x='diabetes_prevalence',
    y='total_deaths_per_million',
    scatter_kws={'s': 50, 'alpha': 0.6},
    line_kws={'color': 'blue'}
)
axes[0].set_title('Diabetes vs. Total deaths per million')
axes[0].set_xlabel('Diabetes prevalence(%)')
axes[0].set_ylabel('Deaths per million')
axes[0].text(0.05, 0.95, f'r = {r_diabetes:.2f}', transform=axes[0].transAxes,
             fontsize=12, verticalalignment='top', bbox=dict(boxstyle='round', facecolor='white', alpha=0.5))

for i, row in filtered_df.iterrows():
    axes[0].text(row['diabetes_prevalence'], row['total_deaths_per_million'], row['location'], fontsize=8)

#cardiopaty
sns.regplot(
    ax=axes[1],
    data=filtered_df,
    x='cardiovasc_death_rate',
    y='total_deaths_per_million',
    scatter_kws={'s': 50, 'alpha': 0.6},
    line_kws={'color': 'red'}
)
axes[1].set_title('Cardiovasc. death rate vs. Total deaths per million')
axes[1].set_xlabel('Cardiovasc death rate')
axes[1].set_ylabel('Deaths per million')
axes[1].text(0.05, 0.95, f'r = {r_cardio:.2f}', transform=axes[1].transAxes,
             fontsize=12, verticalalignment='top', bbox=dict(boxstyle='round', facecolor='white', alpha=0.5))

for i, row in filtered_df.iterrows():
    axes[1].text(row['cardiovasc_death_rate'], row['total_deaths_per_million'], row['location'], fontsize=8)

plt.tight_layout()
plt.savefig('diabetes_cardiovasc_deaths.png', dpi=300)
plt.show()
