import pandas as pd
import plotly.graph_objs as go
from plotly.offline import plot
from plotly.subplots import make_subplots

df = pd.read_csv("norway_covid_2020_2024.csv")

print(df.head())

df["date"] = pd.to_datetime(df["date"])

df = df.sort_values("date")

df["daily_cases"] = df["total_cases"].diff().fillna(0)  # daily cases
df["daily_deaths"] = df["total_deaths"].diff().fillna(0)  #daily deaths

fig = make_subplots(specs=[[{"secondary_y": True}]])

fig.add_trace(go.Scatter(
    x=df["date"],
    y=df["daily_cases"],
    mode='lines+markers',
    name='Daily cases',
    line=dict(color='blue'),
    opacity=0.6,  #transparency bc i cannot see it
    hovertemplate='<b>Daily cases</b><br>Date: %{x}<br>Cases: %{y}<extra></extra>'  # Personalizar hover
),secondary_y=False)

fig.add_trace(go.Scatter(
    x=df["date"],
    y=df["daily_deaths"],
    mode='lines+markers',
    name='Daily deaths',
    line=dict(color='red'),
    opacity=0.6,  #transp
    hovertemplate='<b>Daily deaths</b><br>Date: %{x}<br>Deaths: %{y}<extra></extra>'  # Personalizar hover
),secondary_y=True)

fig.update_layout(
    title="Cases and Daily deaths of COVID-19 in Norway (2020-2024)",
    xaxis_title="Date",
    yaxis_title="Number",
    hovermode='closest',  
    template='plotly'
)

plot(fig, filename="norway_covid_daily_cases_deaths.html")
