# -*- coding: utf-8 -*-
"""
Created on Sun May  4 17:38:08 2025

@author: glori
"""
import pandas as pd
import plotly.graph_objects as go

df = pd.read_csv("owid-covid-data.csv")  # Use your actual file path
df['date'] = pd.to_datetime(df['date'])

countries = ["Norway", "Sweden", "Finland", "Romania", "Brazil", "South Korea", "India"]
indicators = ["people_fully_vaccinated_per_hundred", "total_deaths_per_million", "total_cases_per_million"]

latest_df = (
    df[df["location"].isin(countries)]
    .dropna(subset=indicators)
    .sort_values("date")
    .groupby("location")
    .last()
    .reset_index()
)

normalized_df = latest_df[["location"] + indicators].copy()
for col in indicators:
    normalized_df[col] = (normalized_df[col] - normalized_df[col].min()) / (normalized_df[col].max() - normalized_df[col].min())

fig = go.Figure()
for _, row in normalized_df.iterrows():
    fig.add_trace(go.Scatterpolar(
        r=row[indicators].values,
        theta=["% Fully Vax", "Deaths/Million", "Cases/Million"],
        fill='toself',
        name=row['location']
    ))

fig.update_layout(
    title="🌐 COVID-19 Country Comparison Radar Chart (Normalized)",
    polar=dict(radialaxis=dict(visible=True, range=[0, 1])),
    template="plotly_dark",
    showlegend=True
)

fig.write_html("radar_country_profiles.html")

fig.show()
