# -*- coding: utf-8 -*-
"""
Created on Sun May  4 17:16:38 2025

@author: glori
"""

import pandas as pd

df = pd.read_csv("owid-covid-data.csv") 

countries = {
    "Norway": "norway_covid.csv",
    "Sweden": "sweden_covid.csv",
    "Finland": "finland_covid.csv",
    "Romania": "romania_covid.csv",
    "Brazil": "brazil_covid.csv",
    "South Korea": "south_korea_covid.csv",
    "India": "india_covid.csv"
}

for country, filename in countries.items():
    country_df = df[df["location"] == country]
    country_df.to_csv(filename, index=False)
    print(f"Saved {country} data to {filename}")
