# -*- coding: utf-8 -*-
"""
Created on Sun May  4 17:20:38 2025

@author: glori
"""

import pandas as pd
import plotly.graph_objects as go

df = pd.read_csv("owid-covid-data.csv") 
df["date"] = pd.to_datetime(df["date"])

countries = ["Norway", "Sweden", "Finland", "Romania", "Brazil", "South Korea", "India"]

df = df[df["location"].isin(countries)]
df = df[["location", "date", "new_cases_per_million"]].dropna()

fig = go.Figure()

for country in countries:
    df_c = df[df["location"] == country]
    fig.add_trace(go.Scatter(
        x=df_c["date"],
        y=df_c["new_cases_per_million"],
        mode="lines",
        name=country,
        visible=True
    ))

buttons = []
for i, country in enumerate(countries):
    visible = [False] * len(countries)
    visible[i] = True
    buttons.append(dict(label=country,
                        method="update",
                        args=[{"visible": visible},
                              {"title": f"Daily New Cases per Million – {country}"}]))

buttons.insert(0, dict(label="All",
                       method="update",
                       args=[{"visible": [True]*len(countries)},
                             {"title": "Daily New Cases per Million – All Countries"}]))

fig.update_layout(
    updatemenus=[dict(
        active=0,
        buttons=buttons,
        direction="down",
        showactive=True,
        x=1.15,
        y=1.05
    )],
    title="Daily New COVID-19 Cases per Million – All Countries",
    xaxis_title="Date",
    yaxis_title="Cases per Million",
    template="plotly_dark"
)

fig.write_html("daily_cases_toggle_multi.html")

fig.show()
