# -*- coding: utf-8 -*-
"""
Created on Sun May  4 17:31:08 2025

@author: glori
"""

import pandas as pd
import plotly.express as px

df = pd.read_csv("owid-covid-data.csv")
df['date'] = pd.to_datetime(df['date'])

countries = ["Norway", "Sweden", "Finland", "Romania", "Brazil", "South Korea", "India"]

latest_data = (
    df[df['location'].isin(countries)]
    .sort_values('date')
    .dropna(subset=["people_fully_vaccinated_per_hundred", "total_deaths_per_million", "population"])
    .groupby("location")
    .last()
    .reset_index()
)

fig = px.scatter(
    latest_data,
    x="people_fully_vaccinated_per_hundred",
    y="total_deaths_per_million",
    size="total_cases",
    color="location",
    hover_name="location",
    text="location",
    labels={
        "people_fully_vaccinated_per_hundred": "% Fully Vaccinated",
        "total_deaths_per_million": "Total Deaths per Million"
    },
    title="COVID-19 Impact: Vaccination vs Total Deaths (Selected Countries)",
    template="plotly_dark",
    size_max=60
)


fig.write_html("bubble_vax_vs_deaths.html")

fig.show()
