import pandas as pd
import plotly.graph_objects as go
import altair as alt

df = pd.read_csv("norway_covid_2020_2024.csv")  
df = df[df["location"] == "Norway"]
df["date"] = pd.to_datetime(df["date"])

df1 = df[["date", "new_cases_smoothed", "stringency_index"]].dropna()

fig = go.Figure()
fig.add_trace(go.Scatter(
    x=df1["date"],
    y=df1["new_cases_smoothed"],
    name="New cases (prom. 7 days)",
    yaxis="y1"
))
fig.add_trace(go.Scatter(
    x=df1["date"],
    y=df1["stringency_index"],
    name="Stringency index",
    yaxis="y2",
    line=dict(dash="dot")
))

fig.update_layout(
    title="New cases vs. Stringency index in Norway",
    xaxis_title="Date",
    yaxis=dict(title="New cases"),
    yaxis2=dict(title="Stringency index", overlaying='y', side='right'),
    legend=dict(x=0.01, y=0.99)
)

fig.write_html("casesvsrestrictions.html")


