import pandas as pd
import plotly.graph_objs as go
from plotly.offline import plot
from plotly.subplots import make_subplots


df = pd.read_csv("norway_covid_2020_2024.csv")

print(df.head())

print(df.columns)

df["date"] = pd.to_datetime(df["date"])


fig = make_subplots(specs=[[{"secondary_y": True}]])

fig.add_trace(go.Scatter(
    x=df["date"],
    y=df["total_cases"],
    mode='lines+markers',
    name='Total cases'),secondary_y=False
)

fig.add_trace(go.Scatter(
    x=df["date"],
    y=df["total_deaths"],
    mode='lines+markers',
    name='Total deaths'),secondary_y=True
)

fig.update_layout(
    title="Evolution of cases and total deaths in Norway (2020-2024)",
    xaxis_title="Date",
    yaxis_title="Number",
    hovermode='x unified'
)

plot(fig, filename="norway_covid_cases_deaths.html")


