# -*- coding: utf-8 -*-
fig = go.Figure()

fig.add_trace(go.Scatter(
    x=df['date'],
    y=df['new_deaths'],
    mode='lines',
    name='daily deaths'
))

fig.add_trace(go.Scatter(
    x=df['date'],
    y=df['weekly_avg_deaths'],
    mode='lines',
    name='7 days average'
))

fig.update_layout(title='Daily COVID-19 Deaths in Mexico (with 7-day average)')

fig.show()

import matplotlib.pyplot as plt
import seaborn as sns
import matplotlib.dates as mdates

sns.set_style("whitegrid")
plt.style.use('ggplot')

fig, ax1 = plt.subplots(figsize=(14, 6))

# new cases
color_cases = 'tab:blue'
ax1.set_xlabel('Date')
ax1.set_ylabel('new daily cases', color=color_cases)

# moving average
ax1.plot(df['date'], df['new_cases_7_day_avg_right'], color=color_cases, linestyle='-', linewidth=2, label='New cases')
plt.xticks(rotation=45)
ax1.tick_params(axis='y', labelcolor=color_cases)
ax1.legend(loc='upper left')

# deaths
ax2 = ax1.twinx()
color_deaths = 'tab:red'
ax2.set_ylabel('daily deaths', color=color_deaths)


ax2.plot(df['date'], df['new_deaths_7_day_avg_right'], color=color_deaths, linestyle='-', linewidth=2, label='Deaths')
ax2.tick_params(axis='y', labelcolor=color_deaths)
ax2.legend(loc='upper right')

plt.xticks(rotation=45)
plt.title('New Daily Cases of COVID-19 in Mexico and daily number of deaths (7 days average)')
fig.tight_layout()
plt.gca().xaxis.set_major_formatter(mdates.DateFormatter('%Y-%m'))
plt.gca().xaxis.set_major_locator(mdates.MonthLocator(interval=3))
plt.xticks(rotation=45)
plt.show()