# -*- coding: utf-8 -*-
plt.figure(figsize=(12, 6))

plt.plot(df['date'], df['total_cases'], label='all COVID-19 cases in total', color='navy', linewidth=2)
plt.plot(df['date'], df['total_deaths'], label='all COVID-19 deaths in total', color='maroon', linewidth=2)

plt.xlabel('Date')
plt.ylabel('total number')
plt.title('Total Number of COVID-19 Cases and Deaths in Mexico')
plt.legend()
plt.gca().xaxis.set_major_formatter(mdates.DateFormatter('%Y-%m'))
plt.gca().xaxis.set_major_locator(mdates.MonthLocator(interval=3))
plt.xticks(rotation=45)
plt.grid(True, which='both', linestyle='--', linewidth=0.5)
plt.tight_layout()
plt.show()

fig, ax1 = plt.subplots(figsize=(12, 6))
color1 = 'navy'
ax1.set_xlabel('Data')
ax1.set_ylabel('all COVID-19 cases in total', color=color1)
ax1.plot(df['date'], df['total_cases'], color=color1, linewidth=2, label='all COVID-19 cases in total')
ax1.tick_params(axis='y', labelcolor=color1)
plt.xticks(rotation=45)
ax1.legend(loc='upper left')

ax2 = ax1.twinx()
color2 = 'maroon'
ax2.set_ylabel('all COVID-19 deaths in total', color=color2)
ax2.plot(df['date'], df['total_deaths'], color=color2, linewidth=2, label='all COVID-19 deaths in total')
ax2.tick_params(axis='y', labelcolor=color2)
ax2.legend(loc='lower right')

plt.title('Total Number of COVID-19 Cases and Deaths in Mexico')
plt.xticks(rotation=45)
fig.tight_layout()
plt.gca().xaxis.set_major_formatter(mdates.DateFormatter('%Y-%m'))
plt.gca().xaxis.set_major_locator(mdates.MonthLocator(interval=3))
plt.xticks(rotation=45)
plt.show()

"""##Vaccinations, Vaccinations by age and Vaccinations by manufacturer"""

# https://catalog.ourworldindata.org/garden/covid/latest/vaccinations_global/vaccinations_global.csv
# https://catalog.ourworldindata.org/garden/covid/latest/vaccinations_age/vaccinations_age.csv
# https://catalog.ourworldindata.org/garden/covid/latest/vaccinations_manufacturer/vaccinations_manufacturer.csv

df_vac=pd.read_csv("https://catalog.ourworldindata.org/garden/covid/latest/vaccinations_global/vaccinations_global.csv")

df_vac=df_vac[df_vac['country']=='Mexico']

df_vac=df_vac.reset_index(drop=True)

df_vac['total_vaccinations'] = df_vac['total_vaccinations'].fillna(method='ffill')

df_vac['date'] = pd.to_datetime(df_vac['date'])

deaths_column_to_plot = 'weekly_deaths'
deaths_label = 'daily deaths (7-days average)'
df_vac['date'] = pd.to_datetime(df_vac['date'])

# Tworzenie wykresu
fig, ax1 = plt.subplots(figsize=(14, 7))

# Oś dla zgonów (z DataFrame 'df')
color_deaths = 'tab:red'
ax1.set_xlabel('Date')
ax1.set_ylabel(deaths_label, color=color_deaths)
ax1.plot(df['date'], df[deaths_column_to_plot], color=color_deaths, linewidth=2, label=deaths_label)
ax1.tick_params(axis='y', labelcolor=color_deaths)
ax1.legend(loc='upper left')
plt.xticks(rotation=45)

# Oś dla szczepień (z DataFrame 'df_vac')
ax2 = ax1.twinx()
color_vaccinations = 'tab:green'
ax2.set_ylabel('total number of vaccinated people', color=color_vaccinations)
# Wykres liniowy dla total_vaccinations - zacznie się rysować od daty, gdzie dane są dostępne
ax2.plot(df_vac['date'], df_vac['total_vaccinations'], color=color_vaccinations, linewidth=2, linestyle='--', label='total number of vaccinated people')
ax2.tick_params(axis='y', labelcolor=color_vaccinations)
ax2.legend(loc='upper right')

# Dodanie pionowej linii oznaczającej początek szczepień (opcjonalnie)
if not df_vac.empty: # Sprawdź czy df_vac nie jest pusty
    first_vaccination_date = df_vac['date'].min()
    if pd.notnull(first_vaccination_date):
        ax1.axvline(x=first_vaccination_date, color='gray', linestyle=':', linewidth=1.5, label=f'begining of vaccinations in Mexico ({first_vaccination_date.strftime("%Y-%m-%d")})')
        # Aktualizacja legendy ax1
        handles1, labels1 = ax1.get_legend_handles_labels()
        ax1.legend(handles1, labels1, loc='upper left')


plt.title('Daily Deaths and Total Number of Vaccinated People in Mexico')
fig.tight_layout()
ax1.xaxis.set_major_formatter(mdates.DateFormatter('%Y-%m'))
ax1.xaxis.set_major_locator(mdates.MonthLocator(interval=3)) # Dostosuj interwał dla czytelności
plt.xticks(rotation=45)

# Ustawienie limitów osi X, aby objąć cały zakres dat z obu DataFrame'ów
min_date = min(df['date'].min(), df_vac['date'].min() if not df_vac.empty else df['date'].min())
max_date = max(df['date'].max(), df_vac['date'].max() if not df_vac.empty else df['date'].max())
ax1.set_xlim([min_date, max_date])

plt.show()

deaths_column_to_plot = 'cfr_100_cases'
deaths_label = 'CFR (%)'
df_vac['date'] = pd.to_datetime(df_vac['date'])

fig, ax1 = plt.subplots(figsize=(14, 7))

# CFR
color_deaths = 'tab:red'
ax1.set_xlabel('Data')
ax1.set_ylabel(deaths_label, color=color_deaths)
ax1.plot(df['date'], df[deaths_column_to_plot].rolling(window=7, center=True, min_periods=1).mean() , color=color_deaths, linewidth=2, label=deaths_label)
ax1.tick_params(axis='y', labelcolor=color_deaths)
ax1.legend(loc='upper left')
plt.xticks(rotation=45)

# VAC
ax2 = ax1.twinx()
color_vaccinations = 'tab:green'
ax2.set_ylabel('Number of People Vaccinated', color=color_vaccinations)

ax2.plot(df_vac['date'], df_vac['total_vaccinations'], color=color_vaccinations, linewidth=2, linestyle='--', label='number of people vaccinated')
ax2.tick_params(axis='y', labelcolor=color_vaccinations)
ax2.legend(loc='upper right')

#vertical line
first_vaccination_date = df_vac['date'].min()
if pd.notnull(first_vaccination_date):
    ax1.axvline(x=first_vaccination_date, color='gray', linestyle=':', linewidth=1.5, label=f'begining of vaccinations ({first_vaccination_date.strftime("%Y-%m-%d")})')

    handles1, labels1 = ax1.get_legend_handles_labels()
    ax1.legend(handles1, labels1, loc='upper left')


plt.title('Case Fatality Rate vs Total Number of People Vaccinated in Mexico')
fig.tight_layout()
ax1.xaxis.set_major_formatter(mdates.DateFormatter('%Y-%m'))
ax1.xaxis.set_major_locator(mdates.MonthLocator(interval=3))
plt.xticks(rotation=45)

# Ustawienie limitów osi X, aby objąć cały zakres dat z obu DataFrame'ów
min_date = min(df['date'].min(), df_vac['date'].min() if not df_vac.empty else df['date'].min())
max_date = max(df['date'].max(), df_vac['date'].max() if not df_vac.empty else df['date'].max())
ax1.set_xlim([min_date, max_date])

plt.show()

"""## testing"""

# https://catalog.ourworldindata.org/garden/covid/latest/testing/testing.csv

# daily_tests_evolution.py

import pandas as pd
import matplotlib.pyplot as plt
import matplotlib.dates as mdates

df = pd.read_csv("testing.csv", parse_dates=["date"])
df = (
    df[df["country"].isin(["Mexico", "Poland"])]
      .dropna(subset=["total_tests_per_thousand"])
      .copy()
)

# Plot